<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;


class ApplicationSearch extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [

            'id' => encode($this->id),
            'assignTo'=> encode($this->assignTo),
            'assignToName'=> agent_info($this->assignTo,'name').''.agent_info($this->assignTo,'last_name'),
            'applyFor' => $this->applyFor,
            'applyForOther' => $this->applyForOther,
            $this->mergeWhen(Auth::user()->isCompany(), [
               'studentID' => encode($this->user_id),
               'firstName' => $this->user->name.' '.$this->user->last_name,
               'lastName' => $this->user->dateOfbirth,
               'phone' => $this->user->phone,
               'email' => $this->user->email,
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
               'studentID' => encode($this->user_id),
               'firstName' => $this->user->name.' '.$this->user->last_name,
               'lastName' => $this->user->dateOfbirth,
               'phone' => $this->user->phone,
               'email' => $this->user->email,
            ]),
            $this->mergeWhen(Auth::user()->isAssociates(), [
               'studentID' => encode($this->user_id),
               'firstName' => $this->user->name.' '.$this->user->last_name,
               'lastName' => $this->user->dateOfbirth,
               'phone' => $this->user->phone,
               'email' => $this->user->email,
            ]),
            $this->mergeWhen(Auth::user()->isStaff(), [
               'studentID' => encode($this->user_id),
               'firstName' => $this->user->name.' '.$this->user->last_name,
               'lastName' => $this->user->dateOfbirth,
               'phone' => $this->user->phone,
               'email' => $this->user->email,
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
               'studentID' => encode($this->user_id),
               'firstName' => $this->user->name.' '.$this->user->last_name,
               'lastName' => $this->user->dateOfbirth,
               'phone' => $this->user->phone,
               'email' => $this->user->email,
            ]),
            'application_number' => $this->application_number,
            'type'=>'application',
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

        ];
    }
}
