<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;
use App\Http\Resources\ServiceOrders as ServiceOrdersResource;

class Invoice extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $admin_id = ownerKeyId(secret_key_get());
        return [
           
            'id' => encode($this->id),
            'orderId'=> encode($this->order_id),
            'invoiceId'=>  $this->invoice_id,
            'dateof' => $this->dateof,
            'items' => $this->items,
            'baseAmount'=>  $this->baseAmount,
            'amount' => $this->amount,
            'paymentType' =>  $this->paymentType,
            
            'taxRate1'=>  $this->taxRate1,
            'taxAmount1'=> $this->taxAmount1,
            'taxRate2' => $this->taxRate2,
            'taxAmount2' => $this->taxAmount2,
            
            'grandTotal'=> $this->grand_total,
            'invoiceCreateBy' => getUserInfo($this->generatedBy,'name').' '.getUserInfo($this->generatedBy,'last_name'),
            'cancel'=>  $this->status_cancel,
            'notes'=>  $this->notes,
            'cancelBy' =>getUserInfo($this->cancel_by,'name').' '.getUserInfo($this->cancel_by,'last_name'),
            'orderDetails'=> ServiceOrdersResource::collection(\App\Model\Api\Invoice\Orders::where('administer_id',$admin_id)->where('id',  $this->order_id)->get()),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
