$(document).ready(function() {

    $(".viewPannel").click(function() {
        var $this = $(this);
        $("#" + $this.attr('data-form')).fadeOut();
        $("#" + $this.attr('data-view')).fadeIn();
        $("#" + $this.attr('data-edit')).fadeIn();
    });

    $(".editProfile").click(function() {
        var $this = $(this);
        var $view = $this.attr('data-view');
        var $form = $this.attr('data-form');
        $("#" + $view).fadeOut();
        $("#" + $form).fadeIn();
        $this.fadeOut();
    });


    $("#profileFormSave").submit(function(e) {
        console.log("Run");
        $("#profileLoader").show();
        e.preventDefault();
        var form = $('#profileFormSave').get(0);
        var formData = new FormData(form);
        formData.append('type', 'general');
        $(this).submitFormData(formData, 'profile');
    });

    $("#familyFormSave").submit(function(e) {
        $("#familyLoader").show();
        e.preventDefault();
        var form = $('#familyFormSave').get(0);
        var formData = new FormData(form);
        formData.append('type', 'family');
        $(this).submitFormData(formData, 'family');
    });

    $("#educationFormSave").submit(function(e) {
        $("#educationLoader").show();
        e.preventDefault();
        var form = $('#educationFormSave').get(0);
        var formData = new FormData(form);
        formData.append('type', 'education');
        $(this).submitFormData(formData, 'education');
    });

    $("#expFormSave").submit(function(e) {
        $("#expLoader").show();
        e.preventDefault();
        var form = $('#expFormSave').get(0);
        var formData = new FormData(form);
        formData.append('type', 'exp');
        $(this).submitFormData(formData, 'exp');
    });

    $("#mailFormSave").submit(function(e) {
        $("#mailLoader").show();
        e.preventDefault();
        var form = $('#mailFormSave').get(0);
        var formData = new FormData(form);
        formData.append('type', 'mail');
        $(this).submitFormData(formData, 'mail');
    });

    function fetchProfileInformation(studentId, type) {
        $("#" + type + "View").html('<h4>Fetching information .... </h4><div class="spinner-border text-blue" role="status"></div>');

        $.ajax({
            type: 'post',
            dataType: 'json',
            data: 'studentId=' + studentId + "&type=" + type + "&_token=" + $('meta[name="csrf-token"]').attr('content'),
            url: "/" + role + '/students/load-profile-data',
            success: function(result) {
                if (result.success) {
                    $("#" + type + "View").html(result.html);
                    $('.hiddenData').html(result.hiddendata);
                }
            },
            error: function(result) {
                $("#" + type + "View").html('<h3>Something went wrong. Please try after some time.</h3>');
                alert("Something went wrong. Please try after some time.");

            },
            fail: function(result) {
                $("#" + type + "View").html('<h3>Something went wrong. Please try after some time.</h3>');
                alert("Something went wrong. Please try after some time.");
            }

        });
    }

    function fetchApplicationInformation(studentId) {
        $("#applictionView").html('<h4>Fetching information .... </h4><div class="spinner-border text-blue" role="status"></div>');

        $.ajax({
            type: 'post',
            dataType: 'json',
            data: 'studentId=' + studentId + "&_token=" + $('meta[name="csrf-token"]').attr('content'),
            url: "/" + role + '/application/load-application-data',
            success: function(result) {
                if (result.success) {
                    $("#applictionView").html(result.html);
                } else if (result.error) {
                    $.each(result.error, function(k, v) {
                        alert("Error - " + v[0]);
                    });
                }
            },
            error: function(result) {
                $("#applictionView").html('<h3>Something went wrong. Please try after some time.</h3>');
                alert("Something went wrong. Please try after some time.");

            },
            fail: function(result) {
                $("#" + type + "View").html('<h3>Something went wrong. Please try after some time.</h3>');
                alert("Something went wrong. Please try after some time.");
            }
        });
    }

    $.fn.submitFormData = function(formdata, type) {

        $.ajax({
            type: 'post',
            dataType: 'json',
            data: formdata,
            processData: false,
            contentType: false,
            url: "/" + role + '/students/edit/' + $("#studentId").val(),
            success: function(result) {
                $('.profileLoad').hide();

                if (result.error) {
                    $.each(result.error, function(k, v) {
                        alert("Error - " + v[0]);
                    });
                } else if (result.success) {
                    $('#' + type + '_form').fadeOut();
                    $('#' + type + 'View').fadeIn();
                    $("#" + type + "Button").fadeIn();

                    fetchProfileInformation($("#studentId").val(), type);

                    if (type == "family") {
                        fetchProfileInformation($("#studentId").val(), "profile");
                        $('#profileMartial').val($("#familyMartial").val()).change();
                    }
                    if (type == "profile") {
                        fetchProfileInformation($("#studentId").val(), "family");
                        $('#familyMartial').val($("#profileMartial").val()).change();
                    }
                }





            },
            error: function(result) {

                console.log("Information  " + result.success);
                $.each(result.success, function(k, v) {
                    console.log("Key " + k + " V " + v[0]);
                })
                $('.profileLoad').hide();
                alert("Something went wrong. Please try after some time.");

            },
            fail: function(result) {
                $('.profileLoad').hide();
                alert("Something went wrong. Please try after some time.");
            }

        });
    }


    /*Application Data*/

    $("#applicaitonNew").submit(function(e) {
        $('#notification').html('');
        $("#applicationLoader").show();
        var form = $('#applicaitonNew').get(0);
        var formData = new FormData(form);
        formData.append('studentId', $("#studentId").val());
        formData.append('json', 'json');
        e.preventDefault();
        $.ajax({
            type: 'post',
            dataType: 'json',
            data: formData,
            processData: false,
            contentType: false,
            url: "/" + role + '/application/add-new',
            success: function(result) {
                $("#applicationLoader").hide();
                $("#applicaitonNew")[0].reset();
                //fetchApplicationInformation($("#studentId").val());
                if (result.success) {
                    window.location.reload()
                    $('#notification').html('<div class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&#215;</button><strong>Success:' + result.success + ' </strong> </div>');
                } else {
                    window.location.reload()
                    $('#notification').html('<div class="alert alert-danger alert-dismissable"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&#215;</button><strong>Success:' + result.error + ' </strong> </div>');
                }


            },
            error: function(result) {
                $("#applicationLoader").hide();
                alert("Something went wrong. Please try after some time.");

            },
            fail: function(result) {
                $("#applicationLoader").hide();
                alert("Something went wrong. Please try after some time.");
            }

        });


    });


    /*Marriage*/

    $(function() {
        $(this).familySet($(".married_status").val());
    });
    $(".married_status").change(function() {
        $(this).familySet($(this).val());
    });

    $(".prevmarried").change(function() {
        $(this).prevMarried($(this).val());
    });

    $.fn.familySet = function(mariageStatus) {

        if (mariageStatus == "Married") {
            $(".divorce_details").hide();
            $(".family_details").show();
            $(".divorce_details :input").prop('disabled', true);
            $(".family_details :input").prop('disabled', false);

            $(this).prevMarried($('.prevmarried:checked').val());

        } else if (mariageStatus == "Divorce") {
            $(".divorce_details").show();
            $(".family_details").hide();
            $(".divorce_details :input").prop('disabled', false);
            $(".family_details :input").prop('disabled', true);
            $(this).prevMarried($('.prevmarried:checked').val());
        } else {
            $(this).prevMarried($('.prevmarried:checked').val());
            $(".divorce_details").hide();
            $(".family_details").hide();
            $(".divorce_details :input").prop('disabled', true);
            $(".family_details :input").prop('disabled', true);

        }


    }

    $.fn.prevMarried = function(status) {
        if (status == "No") {

            $(".prev_marriage_container").hide();
            $(".prev_marriage_container :input").prop('disabled', true);
        } else {

            $(".prev_marriage_container").show();
            $(".prev_marriage_container :input").prop('disabled', false);
        }
    }

    $(".mailingAddSame").change(function() {
        var $this = $(this);
        if ($this.val() == "1") {
            $(".address").val($("input[name=address]").val());
            $(".city").val($("input[name=city]").val());
            $(".state").val($("input[name=state]").val());
            $(".district").val($("input[name=district]").val());
            $(".zip").val($("input[name=zipcode]").val());
            $(".country").val($("input[name=country]").val());
        } else {
            $(".address").val('');
            $(".city").val('');
            $(".state").val('');
            $(".district").val('');
            $(".zip").val('');
            $(".country").val('');

        }
    });



});