<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\RetrainerAgreement;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\RetrainerAgreement as RetrainerAgreementResource;


class RetrainerAgreementController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }
    
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'studentID'=> 'required',
            'agreementFile'=>'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        
        $input = $request->all();
        if($request->hasFile('agreementFile')){
           $input['agreementFile'] = $this->common->fileUpload($request->file('agreementFile'),'uploads/document/retrainer_agreement/');
        }
        
        $is_student = \App\User::where('id',  decode($input['studentID']))
                ->where('role',4)
                ->where('owner_key',Auth::user()->secret_key)
                ->count();
        
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        
        $input['assignedByAdmin']=Auth::id();
        $input['studentID'] = decode($input['studentID']);
        
        $data = new RetrainerAgreement($input);
        if($data->save()){
            return response()->json(['success'=>"Document has been assigned successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function show($id=0){
        if($id=="0"){
            return response()->json(['error'=>"Invalid Student ID"], 401);          
        }
        
        $is_student = \App\User::where('id',  decode($id))
                ->where('role',4)
                ->where('owner_key',Auth::user()->secret_key)
                ->count();
        
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);       
        }
        
        $list['data'] =  RetrainerAgreementResource::collection(RetrainerAgreement::has('user')->with('user','assignerAgent')->where('assignedByAdmin',Auth::id())->where('studentID',  decode($id))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function delete($id){
        $id = decode($id);
        $delete = RetrainerAgreement::where('assignedByAdmin',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
    }
    function message_errors(){
        return [
            'agreementFile.required'=> 'Please provide the valid path of document',
            'docID.required'=>'Document ID Required',
            'studentID.required'=>'Valid Student ID Required',
        ];
    }
    
}
