<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Application;
use App\Model\Api\Applicationservice;
use App\Model\Api\ApplicationAssignedFilter;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Application as ApplicationResource;

use App\Model\Api\ApplicationLog;
use App\Http\Resources\ApplicationLog as ApplicationResourceLog;
use App\Model\Api\Events;
use DB;

class ApplicationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'applyFor' => 'required',
            'studentId' =>'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        
        
        $adminId = 0;
        $is_student_query = \App\User::where('id',  decode($input['studentId']))->where('role',4);
        //if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role ==5 || Auth::user()->role ==7){
            $is_student_query->where('owner_key',secret_key_get());
            $adminId = ownerKeyId( secret_key_get() );
        /*}else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
            $adminId = ownerKeyId( secret_key_get() );
        }*/
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);
        }

        /*if(Auth::user()->role == 7){
            $input['assignTo']=  Auth::id();
        }else{*/
            if($request->input('assign_to')!=""){

                if($request->input('assign_to') !="Admin"){
                    $input['assignTo']=  decode($input['assign_to']);
                }else{
                    $input['assignTo'] = ownerKeyId(secret_key_get());
                }

            }else{
                $input['assignTo'] = 0;
            }

        //}

        if($request->input('status') != ""){
            if($request->input('status') == "Submitted to CIC"){
                $input['decision'] = 'In Processing';
            }
        }

        if($request->input('date_retained') !=""){
            $input['date_retained'] = change_date_format($input['date_retained']);
        }
        
        if($request->input('submitted_to_cic_before_due_date') !=""){
            $input['submitted_to_cic_before_due_date'] = change_date_format($input['submitted_to_cic_before_due_date']);
        }
        $input['user_id']=  decode($input['studentId']);
        if(isset($input['source']) && $input['source']  != '0'){
            $input['source'] = decode($input['source'] );
        }
        $input['administer_id'] =  $adminId;
        $input['office_application_number'] = $this->applicationNumberGenerate( $input['user_id'], $adminId, $input['applyFor'] );
        if(isset($input['custom_field_data'])) {
            $ss = json_decode($input['custom_field_data'], true);
            $sk = [];
            foreach($ss as $s) {
                $s['id'] = $s['id'];
                if($s['type'] == 'Date Picker' && $s['value'] != '') {
                    $s['value'] = change_date_format($s['value']);
                }
                array_push($sk, $s);
            }
            $input['custom_field_data'] = json_encode($sk);
        }
        $data = new Application($input);
        if($data->save()){
            return response()->json(['success'=>"Application has been created successfully", "id" => encode($data->id)], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function applicationNumberGenerate($studentId,$adminId,$applyFor){
        $nameLast='';
        $appy='';
        $studentName = getUserInfo($studentId,'name');
        $studentLastName = getUserInfo($studentId,'last_name');
        $name = substr($studentName,0,3);
        if($studentLastName!=""){
            $nameLast = substr($studentLastName,0,2);
        }

        if($applyFor!="Other"){
            $resultAppName = Applicationservice::where('name',$applyFor)->first();
            if(!empty($resultAppName)){
                $appy = $resultAppName->short;
            }
        }else{
            $appy = substr($applyFor,0,2);
        }

        $appidlast = Application::where('administer_id',$adminId)->count();
        return date('Y').$appy.'-'.$nameLast.$name.'-'.($appidlast + 1);
    }

    function update(Request $request,$id){
        $id = decode($id);

        /*if(Auth::user()->role == "7"){
            $Application_is_associate = Application::where('id',$id)->where('assignTo',Auth::id())->count();

            if(!$Application_is_associate){
                return response()->json(['error'=>'This application is not assigned you.'], 401);
            }
        }*/

        $validator = Validator::make($request->all(), [
            'studentId' =>'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $input = $request->all();
        if(isset($input['custom_field_data'])) {
            $ss = json_decode($input['custom_field_data'], true);
            $sk = [];
            foreach($ss as $s) {
                $s['id'] = $s['id'];
                if($s['type'] == 'Date Picker' && $s['value'] != '') {
                    $s['value'] = change_date_format($s['value']);
                }
                array_push($sk, $s);
            }
            $input['custom_field_data'] = json_encode($sk);
        }
        $is_student_query = \App\User::where('id',  decode($input['studentId']))->where('role',4);
        //if(Auth::user()->role == 2 || Auth::user()->role == 6 || Auth::user()->role ==5 || Auth::user()->role ==7) {
            $is_student_query->where('owner_key',secret_key_get());
        /*}else{
            $is_student_query->where('owner_key',Auth::user()->owner_key);
            $is_student_query->where('agent_id',Auth::id());
        }*/
        $is_student = $is_student_query->count();
        if(!$is_student){
            return response()->json(['error'=>"Invalid student id"], 401);
        }

        if($request->hasFile('uploadDecisionDoc')){
           $input['upload_decision_doc'] = $this->common->fileUpload($request->file('uploadDecisionDoc'),'uploads/application/');
        }

        if($request->input('date_retained') !=""){
            $input['date_retained'] = change_date_format($input['date_retained']);
        }
        
        if($request->input('submitted_to_cic_before_due_date') !=""){
            $input['submitted_to_cic_before_due_date'] = change_date_format($input['submitted_to_cic_before_due_date']);
        }
        if($request->input('expire_date') !="" ){
            $input['expire_date'] = change_date_format($input['expire_date']);
        }
        if($request->input('decision_date') !=""){
            $input['decision_date'] = change_date_format($input['decision_date']);
        }
        if($request->input('date_submit_to_cic') !=""){
            $input['date_submit_to_cic'] = change_date_format($input['date_submit_to_cic']);
        }

        //$input['administer_id'] =  ownerKeyId(secret_key_get());

        /*if(Auth::user()->role == "7"){
            $input['assignTo']=  Auth::id();
        }else{*/
            if($request->input('assign_to')!=""){

                if($request->input('assign_to') !="Admin"){
                    $input['assignTo']=  decode($input['assign_to']);
                }else{
                    $input['assignTo'] = ownerKeyId(secret_key_get());
                }

            }else{
                $input['assignTo'] = 0;
            }
        //}

        if($request->has('source')){
            if($request->input('source') != "0") {
                $input['source'] = decode($request->input('source'));
            } else {
                $input['source'] = $request->input('source');
            }
        }

        $data = Application::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Application has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    public function single($id=0){
        $id = decode($id);
        $query = Application::has('user')->with('user')->where('id',$id);
        // if(Auth::user()->role == "7"){
        //     $query->where('assignTo',Auth::id());
        // }
        $list['data'] =  ApplicationResource::collection($query->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $usersearch =0;
        $data['email']='';
        $data['phone']='';
        $is_agent = '';

        if(count($request->all())){
            $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
            if($request->has('phone')){
                $usersearch=1;
                $data['phone'] = $request->input('phone');
            }
            if($request->has('email')){
                $usersearch=1;
                $data['email'] = $request->input('email');
            }




            if($usersearch){
                $query = Application::whereHas('user', function($user) use($data){
                    if($data['phone']!=""){
                        $user->where('phone',$data['phone']);
                    }
                    if($data['email']!=""){
                        $user->where('email',$data['email']);
                    }
                })->with('user');
            }else{
                $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
            }

            if($request->has('start_date') && $request->has('end_date')){
                if($request->input('start_date') == $request->input('end_date')) {
                    $query->where(DB::raw('DATE(created_at)'), $request->input('start_date'));
                } else {
                    $query->whereBetween('created_at', [$request->input('start_date'), $request->input('end_date').' 23:59:59']);
                }
                
            }


            if($request->has('assign_to')){

                    if($request->input('assign_to') !="Admin"){
                        $query->where('assignTo',decode($request->input('assign_to')));
                    }else{
                        $input['assignedTo'] = ownerKeyId(secret_key_get());
                        $query->where('assignTo',ownerKeyId(secret_key_get()));
                    }

            }
            if($request->has('applyFor')){
                if($request->input('applyFor') == "Other"){
                    $query->where('applyForOther',1);
                }else{
                    $query->where('applyFor',$request->input('applyFor'));
                }
            }
            if($request->has('status')){
                $query->whereIn('status', explode(',', $request->input('status')));
            }
            if($request->has('decision')){
                $query->where('decision',$request->input('decision'));
            }
            if($request->has('application_no')){
                $query->where('application_number',$request->input('application_no'));
            }
            if($request->has('fee')){
                $query->where('fee',$request->input('fee'));
            }
            if($request->has('source')){
                if($request->input('source') != "0") {
                    $query->where('source',decode($request->input('source')));
                } else {
                    $query->where('source',$request->input('source'));
                }
            }
            if($request->has('student')){
                $query->where('user_id',  decode($request->input('student')));
            }
            if($request->has('appliedDate')){

                $query->whereDate('created_at', change_date_format($request->input('appliedDate')));
            }


            if($request->has('college_type')){
                $query->where('college_type',$request->input('college_type'));
            }
            if($request->has('intake')){
                $query->where('intake',$request->input('intake'));
            }
            if($request->has('college')){
                $query->where('college', $request->input('college'));
            }
            if($request->has('campus_name')){
                $query->where('campus', $request->input('campus_name'));
            }
            if($request->has('program_name')){
                $query->where('program', $request->input('program_name'));
            }

            if($request->has('student_college_id')){
                $query->where('student_college_id', $request->input('student_college_id'));
            }
            if($request->has('offer_letter_fees')){
                $query->where('offer_letter_fees', $request->input('offer_letter_fees'));
            }
            if($request->has('student_type')){
                $query->where('student_type', $request->input('student_type'));
            }

            if($request->has('is_college')) {
                $query->where('applyFor', 'like', '%admission%');
            }

            $application = $query;
        }else{
            $application = Application::has('user')->with('user')->where('administer_id', ownerKeyId( secret_key_get() ));
        }

        // if(Auth::user()->role == "7"){
        //     $application->where('assignTo',Auth::id());
        // }

        $limit = 10;
        if($request->has('limit')){
            $limit = $request->input('limit');
        }

        if($request->get('page')){
            $list =  ApplicationResource::collection($application->orderBy('id','desc')->paginate($limit))->response()->getData();
        }else{
           $list['data'] =  ApplicationResource::collection($application->get());
        }


        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function get_filter(){
        $query = ApplicationAssignedFilter::where('administer_id', ownerKeyId(secret_key_get()))->where('user_id', Auth::id())->first();
        $response = array();
        if($query) {
            $response = json_decode($query->filter);
        }
        return response()->json(['success' => $response], $this->successStatus);
    }

    public function save_filter(Request $request){
        $fil = ApplicationAssignedFilter::firstOrNew(array('administer_id' => ownerKeyId(secret_key_get()), 'user_id' => Auth::id()));
        $fil->filter = $request->input('filter');
        $fil->save();
        return response()->json(['success' => true, 'filter' => $request->input('filter')], $this->successStatus);
    }

    public function assign(Request $request){
        if($request->has('status_count')) {
            $c_query = Application::has('user')->with('user')->where('administer_id', ownerKeyId(secret_key_get()));
            if($request->has('status')){
                $c_query = $c_query->where('status', $request->input('status'));
            }
            $count = $c_query->where('assignTo',Auth::id())->count();

            return response()->json(['success'=> true, 'count' => $count], $this->successStatus);
        } else {
            $query = Application::has('user')->with('user')->where('administer_id', ownerKeyId(secret_key_get()));
            $filter = ApplicationAssignedFilter::where('administer_id', ownerKeyId(secret_key_get()))->where('user_id', Auth::id())->first();
            
            if($filter) {
                $response = (array) json_decode($filter->filter);
                $da = array();
                foreach($response as $key => $value) {
                    array_push($da, removeSpace($key));        
                }
                $query->whereIn('status', $da);
            }

            $limit = 10;
            if($request->has('limit')){
                $limit = $request->input('limit');
            }
            if($request->has('keywords') && $request->has('search_column') && $request->has('keywords') != "" && $request->has('search_column') != "") {
                $keywords = strtolower($request->input('keywords'));
                if($request->input('search_column') == 'all') {
                    $query->where(function ($query) use ($keywords) {
                        $query->where('applyFor', 'like', '%' . $keywords . '%')
                            ->orWhere('office_application_number', 'like', '%' . $keywords . '%')
                            ->orWhereHas('user', function($user) use($keywords){
                                $user   ->where('email','like', '%'.$keywords.'%')
                                        ->orWhere(DB::raw("CONCAT(`name`, ' ', `last_name`)"),'like', '%'.$keywords.'%')
                                        ->orWhere('phone','like', '%'.$keywords.'%');
                        });
                    });
                } else if($request->input('search_column') == 'name') {
                    $query->whereHas('user', function($user) use($keywords){
                        $user->where(DB::raw("CONCAT(`name`, ' ', `last_name`)"),'like', '%'.$keywords.'%');
                    });
                } else if($request->input('search_column') == 'phone') {
                    $query->whereHas('user', function($user) use($keywords){
                        $user->where('phone','like', '%'.$keywords.'%');
                    });
                } else if($request->input('search_column') == 'email') {
                    $query->whereHas('user', function($user) use($keywords){
                        $user->where('email','like', '%'.$keywords.'%');
                    });
                } else if($request->input('search_column') == 'application_number') {
                    $query->where('office_application_number', 'like', '%' . $keywords . '%');
                }
                 else if($request->input('search_column') == 'apply_for') {
                    $query->where('applyFor', 'like', '%' . $keywords . '%');
                }
            }
            $query->where('assignTo',Auth::id());
            $application = $query;
            if($request->get('page')){
                $list =  ApplicationResource::collection($application->orderBy('id','desc')->paginate($limit))->response()->getData();
            }else{
               $list['data'] =  ApplicationResource::collection($application->get());
            }
            return response()->json(['success'=>$list], $this->successStatus);
        }
        
    }

    public function delete($id){
        $id = decode($id);
        $status = $this->check_status($id);
        $status_name = $this->check_status($id,'info');
        if($status){
            return response()->json(['error'=>'Now your application status is '.$status_name.'. So you can not delete the application.'], 401);
        }

        $delete = Application::where('administer_id',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Application has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }

    function check_status($id=0,$return ='status'){
        $query = Application::where('administer_id',Auth::id())->where('id',$id);
        if($return == "status"){
            return $query->whereIn('status',['Review','Document Pending'])->count();
        }else{
            $result = $query->first();
            if(!empty($result)){
                return $result->status;
            }
        }
    }

    /*Application Notes*/
    function notes_create(Request $request,$id){
        $validator = Validator::make($request->all(), [
            'note_description' =>'required',
        ],  $this->message_errors());

        $log['application_id'] = decode($id);
        $log['assignedBy'] = Auth::id();
        $log['assignedType'] = Auth::user()->role;
        if($request->hasFile('attachment')){
            $log['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/applicaiton_notes/');
        }
        if($request->has('assignedTo')){
            if($request->input('assignedTo') !="Admin"){
                $log['assignedTo'] = decode($request->input('assignedTo'));
            }else{
                $log['assignedTo'] = adminId(secret_key_get());
            }
        }
        $log['description'] = $request->input('note_description');
        if($request->has('dueDateTime')){
            $log['dueDateTime'] = $request->input('dueDateTime');
        }else{
            $log['dueDateTime'] = '';
        }
        $log['actionSet'] = $request->input('actionSet');
        if($request->input('actionSet') == "Book an Appointment"){

            if($request->has('startDate')){
                $log['startDate'] = $request->input('startDate');
            }else{
                $log['startDate']='';
            }
            if($request->has('endDate')){
                $log['endDate'] = $request->input('endDate');
            }else{
                $log['endDate'] = '';
            }
        }
        $dataLog = new ApplicationLog($log);
        if($dataLog->save()){

            /** Appointment */
            if($request->input('actionSet') == "Book an Appointment"){
                $inputAppData['administer_id'] = ownerKeyId(secret_key_get());
                $inputAppData['createdBy'] = Auth::id();
                //$inputAppData['client_id'] = $data->id;
                $inputAppData['clientType'] = '';
                $inputAppData['assignedTo'] = $log['assignedTo'];
                $inputAppData['type'] = 'Appointment';
                ///$inputAppData['service'] = $input['service'];
                $inputAppData['startDate'] = $log['startDate'] ;
                $inputAppData['endDate'] =  $log['endDate'] ;
                $inputAppData['title'] = 'Appointment -  Via Application';
                $inputAppData['notes'] = $log['description'];
                //$inputAppData['source'] = $input['source'];
                $dataApp = new Events($inputAppData); 
                $dataApp->save();
            }


            return response()->json(['success'=>"Application has been created successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }
    function notes_list($id=0){
        $id = decode($id);
        $list['data'] = ApplicationResourceLog::collection(\App\Model\Api\ApplicationLog::where('application_id',  $id)->orderBy('id','desc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function message_errors(){
        return [
            'fee.in'=>'Fee value should be [Paid,Unpaid]',
            'expire_date'=>'YYYY-MM-DD',
            'studentId'=>'Student ID is required',
            'note_description' => 'Notes  required'

        ];
    }


    public function show_logs(Request $request){
        $query = ApplicationLog::with(['applications_rel'=>function($q){
            $q->Where('administer_id',ownerKeyId(secret_key_get()));
        }]);

        if(count($request->all())){
            if($request->has('follow_date')){
                $query->whereDate('dueDateTime','=', $request->input('follow_date'));
            }
            if($request->has('followstatus')){
                if($request->input('followstatus') !="all"){
                    $query->where('followStatus', $request->input('followstatus'));
                }
            }

            if($request->has('action')){
                if($request->input('action') !="all"){
                    $query->where('actionSet', $request->input('action'));
                }
            }

            if($request->has('assignedto') && $request->input('assignedto')!=""){
                if($request->input('assignedto') !="Admin"){
                    $query->where('assignedTo',decode($request->input('assignedto')));
                }else{
                    $query->where('assignedTo',adminId(secret_key_get()));
                }
            }
        }
        $list['data'] =  ApplicationResourceLog::collection($query->orderBy('dueDateTime','desc')->get());

        return response()->json(['success'=>$list], $this->successStatus);


    }

    function log_status_update(Request $request,$id){

        $id = decode($id);
        $input = $request->all();
        $comm['followStatus'] = $input['followstatus'];

        $data = ApplicationLog::find($id);
        if($data->update($comm)){
            return response()->json(['success'=>"Record sss ".$id." has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function multipleUpdates(Request $request,$id) {
        $ids = explode(",", $id);
        $arr = [];
        foreach($ids as $id) {
            $id = decode($id);
            $input = array();
            if($request->input('assign_to')!=""){
                if($request->input('assign_to') !="Admin"){
                    $input['assignTo'] =  decode($request->input('assign_to'));
                }else{
                    $input['assignTo'] = ownerKeyId(secret_key_get());
                }
            }
            if($request->input('priority')!=""){
                $input['priority'] = $request->input('priority');
            }
            if($request->input('status')!=""){
                $input['status'] = $request->input('status');
            }
            $app = Application::find($id);
            $app->update($input);
        }

        return response()->json(['success'=>true], $this->successStatus);
        exit();

    }

}
