<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Email;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;

use App\Http\Resources\EmailSent as EmailSentResource;




class EmailSentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){
        $validator = Validator::make($request->all(), [
            'subject' => 'required',
            'message' => 'required',
        ],  $this->message_errors());
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $input['user_id'] = decode($input['user_id']);        
        $data = new Email($input);
        if($data->save()){
            return response()->json(['success'=>"Email sent successfully"], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    public function show($userid, Request $request){
        $list['data'] =  EmailSentResource::collection(Email::where('user_id', decode($userid))->orderBy('id', 'desc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function message_errors(){
        return [
            'subject'=>'Subject is required',
            'status'=>'Message is required',
        ];
    }

}
