<?php

namespace App\Http\Controllers\Api\Manager;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Notes;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Notes as NotesResource;




class NotesController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'postTo' => 'required',
            'notes' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        
        $input['postFrom']=Auth::id();
        $input['postTo'] = decode($input['postTo']);
        $data = new Notes($input);
        if($data->save()){
            return response()->json(['success'=>"Notes has been posted successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'postTo' => 'required',
            'notes' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        $input['postTo'] = decode($input['postTo']);
        $data = Notes::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Note has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function single($id){
        $id = decode($id);
        
        $list['data'] =  NotesResource::collection(Notes::has('user')->with('user')->where('postFrom',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show(){
        $list['data'] =  NotesResource::collection(Notes::has('user')->with('user')->where('postFrom',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Notes::where('postFrom',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Note has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
    }
    
    public function showUser(){
        
        $adminID = ownerKeyId(Auth::user()->owner_key);
        $list['data'] =  NotesResource::collection(Notes::has('user')->with('user')->where('postFrom',$adminID)->where('postTo',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function message_errors(){
        return [
            'postTo.required'=> 'postTo ID is required',
            'notes.required'=> 'Notes value is required',
        ];
    }
    
}
