<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Todaytask;

use Validator;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\Todaytask as TodaytaskResource;




class TodaytaskController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $input = $request->all();
        $input['administer_id'] =  ownerKeyId( secret_key_get() );
        $input['user_id'] = Auth::id();
        $data = new Todaytask($input);
        if($data->save()){
            return response()->json(['success'=>"Today Task has been created successfully","id"=> encode($data->id) ], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function update(Request $request,$id){

        $validator = Validator::make($request->all(), [

            'status' =>'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $id = decode($id);

        $input = $request->all();
        $field['status'] = $input['status'];

        $data = Todaytask::find($id);
        if($data->update($field)){
            return response()->json(['success'=>"Task has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function single($id=0){
        $id = decode($id);
        $list['data'] =  TodaytaskResource::collection(Todaytask::where('administer_id',ownerKeyId( secret_key_get()))->where('id',$id)->where('status',1)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function show(Request $request){
        $list['data'] =  TodaytaskResource::collection(Todaytask::where('administer_id',ownerKeyId( secret_key_get()))->where('user_id',Auth::id())->orderBy('id', 'desc')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Todaytask::where('administer_id',ownerKeyId( secret_key_get()))->where('user_id',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Task has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function message_errors(){
        return [
            'title'=>'Title required',
        ];
    }

}
