<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;


class Application extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [

            'id' => encode($this->id),
            'assignTo'=> encode($this->assignTo),
            'assignedToRole'=>roleName(getUserInfo($this->assignTo,'role')),
            'assignToName'=> agent_info($this->assignTo,'name').' '.agent_info($this->assignTo,'last_name'),
            'applyFor' => $this->applyFor,
            'applicant_name' => $this->applicant_name,
            'applyForOther' => $this->applyForOther,
            'source_agent_id' =>  encode($this->user->agent_id),
            'source_agent_name' =>  agent_info($this->user->agent_id,'name').' '.agent_info($this->user->agent_id,'last_name') ,
            $this->mergeWhen(Auth::user()->isCompany(), [
               'studentID' => encode($this->user_id),
               'studentName' => $this->user->name.' '.$this->user->last_name,
               'studentDateofbirth' => $this->user->dateOfbirth,
               'studentPhone' => $this->user->phone,
               'studentEmail' => $this->user->email,
               'lastUpdateBy' => (Auth::id() == $this->administer_id ? "Admin":"Agent"),
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
               'studentID' => encode($this->user_id),
               'studentName' => $this->user->name.' '.$this->user->last_name,
               'studentDateofbirth' => $this->user->dateOfbirth,
               'studentPhone' => $this->user->phone,
               'studentEmail' => $this->user->email,
               'lastUpdateBy' => (Auth::id() == $this->administer_id ? "You":"Admin"),
            ]),
            $this->mergeWhen(Auth::user()->isAssociates(), [
               'studentID' => encode($this->user_id),
               'studentName' => $this->user->name.' '.$this->user->last_name,
               'studentDateofbirth' => $this->user->dateOfbirth,
               'studentPhone' => $this->user->phone,
               'studentEmail' => $this->user->email,
               'lastUpdateBy' => (Auth::id() == $this->administer_id ? "You":"Admin"),
            ]),
            $this->mergeWhen(Auth::user()->isStaff(), [
               'studentID' => encode($this->user_id),
               'studentName' => $this->user->name.' '.$this->user->last_name,
               'studentDateofbirth' => $this->user->dateOfbirth,
               'studentPhone' => $this->user->phone,
               'studentEmail' => $this->user->email,
               'lastUpdateBy' => (Auth::id() == $this->administer_id ? "Admin":"Agent"),
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
               'studentID' => encode($this->user_id),
               'studentName' => $this->user->name.' '.$this->user->last_name,
               'studentDateofbirth' => $this->user->dateOfbirth,
               'studentPhone' => $this->user->phone,
               'studentEmail' => $this->user->email,
               'lastUpdateBy' => (Auth::id() == $this->administer_id ? "Admin":"Agent"),
            ]),
            'status' => $this->status,
            'details'=>  $this->details,
            'upload_decision_doc'=>asset("uploads/application/". $this->upload_decision_doc),
            'uploadDecisionFile'=>$this->upload_decision_doc,
            'expire_date' => $this->expire_date,
            'fee' => $this->fee,
            'application_number' => $this->application_number,
            'decision_date' =>  $this->decision_date,

            'date_retained' =>  $this->date_retained,
            'priority' =>  $this->priority,
            'office_application_number' =>  $this->office_application_number,
            'officelocation' =>  $this->officelocation,
            'date_submit_to_cic' =>  $this->date_submit_to_cic,
            'cic_application_no' =>  $this->cic_application_no,
            'decision' =>  $this->decision,
            'additional_notes' =>  $this->additional_notes,
            'submitted_to_cic_before_due_date' =>  $this->submitted_to_cic_before_due_date,
            'custom_field_data' =>  $this->custom_field_data,
            'intake' =>  $this->intake,
            'college' =>  $this->college,
            'campus' =>  $this->campus,
            'program' =>  $this->program,
            'application_source' => ($this->source != '0') ? agent_info($this->source,'name').' '.agent_info($this->source,'last_name'): 'Direct',
            'source' =>  $this->source,
            'decode_source' =>  ($this->source == "" || $this->source == 0)? $this->source : encode($this->source),
            'student_college_id' => $this->student_college_id,
            'offer_letter_fees' => $this->offer_letter_fees,
            'student_type' => $this->student_type,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

        ];
    }
}
