<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;
use App\Http\Resources\CommunicationLog as CommunicationlogResource;

class Communication extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            'studentId' => encode($this->studentId),
            'studentName' => $this->user->name.' '.$this->user->last_name,
            'studentPhone' => $this->user->phone,
            'studentEmail' =>$this->user->email,
            'studentAgentID' => encode($this->user->agent_id),
            'studentAgentName' => agent_info($this->user->agent_id,'name').' '.agent_info($this->user->agent_id,'last_name'), 
            'openBy' => getUserInfo($this->openBy,'name').' '.getUserInfo($this->openBy,'last_name'),
            'modiyfyBy' => getUserInfo($this->modifyBy,'name').' '.getUserInfo($this->modifyBy,'last_name'),
            'openByRole'=>roleName(getUserInfo($this->openBy,'role')),
            'source' => $this->source,
            'service'=>  $this->service,
            'notes' => $this->notes,
            'actionSet' => $this->actionSet,
            "assignedTo" =>encode($this->assignedTo),
            'assignedToName' => getUserInfo($this->assignedTo,'name').' '.getUserInfo($this->assignedTo,'last_name'),
            'assignedToRole'=>roleName(getUserInfo($this->assignedTo,'role')),
            "resolutionNotes"=>$this->resolutionNotes,
            'status' =>  $this->status,
            'communicateId'=>  $this->comm_id,
            'startDate'=>  $this->startDate,
            'endDate'=>  $this->endDate,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'communicationLog'=> CommunicationlogResource::collection(\App\Model\Api\CommunicationLog::where('communication_id',  $this->id)->orderBy('id','desc')->get()),
            'name' => $this->name,
            'custom_field_data' => $this->custom_field_data
        ];
    }
}
