<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class DocEdcuation extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    
    public function toArray($request)
    {
        
        return [
            'id' => encode($this->id),
            $this->mergeWhen(Auth::user()->isCompany(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            
            
            'twelfthFile'=> $this->twelfth,
            'twelfth'=>asset("uploads/document/".encode($this->application_id)."/education/". $this->twelfth),
            'graduation'=>asset("uploads/document/".encode($this->application_id)."/education/". $this->graduation),
            'graduationFile'=>$this->graduation,
            'postGraduation'=>asset("uploads/document/".encode($this->application_id)."/education/".  $this->postGraduation),
            'postGraduationFile'=>$this->postGraduation,
            'masters'=>asset("uploads/document/".encode($this->application_id)."/education/".  $this->masters),
            'mastersFile'=>$this->masters,
            'phd'=>asset("uploads/document/".encode($this->application_id)."/education/".  $this->phd),
            'phdFile'=>$this->phd,
            
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
