<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class UsersSearch extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request){
    
        return [
            'id' => encode($this->id),
            'firstName' => $this->name,
            'lastName' => $this->last_name,
            'phone' => ($this->anotherPhone!='')?$this->phone.", ".$this->anotherPhone:$this->phone,
            'email' => ($this->anotherEmail!='')?$this->email.", ".$this->anotherEmail:$this->email,
            'type'=>'client',
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
        
    }
}
