<?php
use App\Http\Controllers\CommonController;
use App\Model\Notification;
use App\Model\Package;
use App\User;

function is_expire($date){
     $common = new CommonController();
     $status= $common->dateManuplationGet( $date, date('Y-m-d'),'equality');
     return $status;

}
function is_expire_html($date){
    $status = is_expire($date);
    if($status == "-1"){
         return "<span class='label label-danger'>Expired</span>";
     }elseif($status == "0"){
         return "<span class='label label-warning'>Expire Soon</span>";
     }
}

function order_status($status = 0){
    switch ($status){
        case "1":
            return "<span class='label label-success'>Completed</span>";
            break;
        case "2":
            return "<span class='label label-success'>Refund</span>";
            break;
        case "3":
            return "<span class='label label-danger'>Cancelled</span>";
            break;
        case "0":
            return "<span class='label label-info'>Completed</span>";
            break;
    }
}

function read_status($id){
    $data = Notification::find($id);
    $data->status = 1;
    $data->save();
}

function get_count_notifications(){
    return Notification::where('to_id',Auth::id())->where('status',0)->count();
}
function get_list_notifications(){
    return Notification::where('to_id',Auth::id())->where('status',0)->get();
}
function notfication_create($data = array()){
    $info = new Notification($data);
    $info->save();
}

/*For Api*/
function secret_key_get(){
    $headers = apache_request_headers();
    if(isset($headers['Secret-Key']) && $headers['Secret-Key'] !="" ){
        return $headers['Secret-Key'];
    }
}





function encode($val){
    if($val){
       return str_replace(array('+', '/','='), array('', '',''), strrev(substr(md5(999),3,4).base64_encode(strrev("`".$val."~".substr(md5($val),0,10).'p04b54'))));
    }

}

function decode($code){
    if($code){
        $val = strrev(base64_decode(str_replace(array('', '',''), array('+', '/','='),strrev($code))));
        $val = ltrim(current(explode('~',$val)),'`');
        return $val;
    }

}

function ownerKeyId($key='',$value ='id'){
    $user = App\User::where('secret_key',$key)->first();
    if(!empty($user)){
        return $user->$value;
    }
}
function agent_info($id=0,$fld){
    if($id){
        $user = \App\User::where('id',$id)->first();
        if(!empty($user)){
            return $user->$fld;
        }
    }

}

function check_file($file,$path=''){
    if($file!=""){
        return asset($path.$file);
    }
}

function is_subscribe($package='',$user_id=''){
    $subscribe = new CommonController();
    return $subscribe->is_subscribe($package, $user_id);
}
function get_active_subscription($user_id=''){
    $subscribe = new CommonController();
    return $subscribe->get_active_subscription($user_id);
}
function package_information($plan_id =0,$field=""){
    $package = Package::where('stripe_id',$plan_id)->first();
    if(!empty($package)){
        if($field!=""){
            return $package->$field;
        }else{
            return $package;
        }

    }
}
function get_payment_method($user_id=''){
    $subscribe = new CommonController();
    return $subscribe->getPaymentMethod($user_id);
}

function invoice_status($status = 0){
    switch ($status){
        case "1":
            return "<span class='label label-success'>Paid</span>";
            break;
        case "2":
            return "<span class='label label-success'>Refund</span>";
            break;
        case "3":
            return "<span class='label label-danger'>Cancelled</span>";
            break;
        case "0":
            return "<span class='label label-info'>Completed</span>";
            break;
    }
}
function country(){
    return \App\Model\Country::get();
}
function adminId($secretKey=''){
    $user = User::where('secret_key',$secretKey)->first();
    if(!empty($user)){
        return $user->id;
    }
}

function getUserInfoLead($id=0,$fld=''){
    $user = App\Model\Api\Leads::where('id',$id)->first();
    if(!empty($user)){
        return $user->$fld;
    }
}
function getUserInfoCommunication($id=0,$fld=''){
    $user = App\Model\Api\Communication::where('id',$id)->first();
    
    if(!empty($user)){
        return $user->$fld;
    }
}
function getUserInfo($id=0,$fld=''){
    $user = User::where('id',$id)->first();
    if(!empty($user)){
        return $user->$fld;
    }
}
function getUserEnable($email=''){
    $secret = secret_key_get();
    $user = User::where('email',$email)
    ->whereRaw("(`secret_key` = '{$secret}' or `owner_key` = '{$secret}')")->first();
   // echo "<pre>"; print_r($user);
    if(!empty($user)){
        if($user->role == "4"){
            if($user->client_enable == 1){
                return 1;
            }else{
                return 0;
            }
        }
    }
    return 1;
}

function getUserMultiProfile($id = 0, $type = '',$field='name'){


        if($type == "profile"){
            return getUserInfo($id,$field);
        }elseif($type == "lead"){
            if($field == "name"){
                $field = 'firstName';
            }

            if($field == "last_name"){
                $field = 'lastName';
            }
            if($field == "phone"){
                $field = 'phoneNumber';
            }
            return getUserInfoLead($id,$field);
        }


}

function profileTypeEvent($type=''){
    if($type == 'profile'){
        return "Client";
    }elseif($type == "lead"){
        return "Lead";
    }
}

function roleName($role=2){
    switch ($role){
        case 2:
            return "Admin";
            break;
        case 3:
            return "Agent";
            break;
        case 4:
            return "Student";
            break;
        case 5:
            return "Staff";
            break;
        case 6:
            return "Manager";
        case 7:
            return "Associate";    
            break;
    }
}

function userEmailExist($email='',$exist=''){
        $secret = secret_key_get();
        $queryUser = User::where('email',$email)
                ->whereRaw("(`secret_key` = '{$secret}' or `owner_key` = '{$secret}')");

        if($exist){
            $queryUser->where('id', '!=',  decode($exist));
        }

        return  $queryUser->count();
}
function userPhoneExist($phone='',$exist=''){
        $secret = secret_key_get();
        $queryUser = User::where('phone',$phone)
                ->whereRaw("(`secret_key` = '{$secret}' or `owner_key` = '{$secret}')");

        if($exist){
            $queryUser->where('id', '!=',  decode($exist));
        }

        return  $queryUser->count();
}

function getLeadEmailExist($email='',$exist=''){

    $adminId = ownerKeyId(secret_key_get());
    $queryUser = \App\Model\Api\Leads::where('email',$email)
            ->where('administer_id',$adminId);

    if($exist!=""){
        $queryUser->where('id', '!=',  decode($exist));
    }

    return  $queryUser->count();
}

function getLeadPhoneExist($phone='',$exist=''){

    $adminId = ownerKeyId(secret_key_get());
    $queryUser = \App\Model\Api\Leads::where('phoneNumber',$phone)
            ->where('administer_id',$adminId);

    if($exist!=""){
        $queryUser->where('id', '!=',  decode($exist));
    }

    return  $queryUser->count();
}

?>
