<?php

namespace App\Http\Controllers\Api\Manager;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\User;
use App\Model\Api\Instruction;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;
use App\Http\Resources\Instruction as InstructionsResource;



class InstructionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'description' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        /*Empty Table*/
        $input = $request->all();
        
        $is_record = Instruction::first();
       
        if($is_record){
            $data = Instruction::find($is_record->id);
            $data->description = $input['description'];
            if($data->update()){
                return response()->json(['success'=>"Record has been saved successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
            
        }else{
            $input['user_id']=Auth::id();
            $data = new Instruction($input);
            if($data->save()){
                return response()->json(['success'=>"Record has been saved successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
    }
    public function show(){
        $list['data'] =  InstructionsResource::collection(Instruction::where('user_id',Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        $delete = Instruction::where('user_id',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function message_errors(){
        return [
            'description.required'=> 'Description field is required',
        ];
    }
    
}
