<?php

namespace App\Http\Controllers\Api\Student;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\DocIdentity;
use Validator;
use Illuminate\Support\Facades\Hash;

use App\Http\Resources\DocIdentity as DocIdentityResource;
use App\Http\Resources\DocEdcuation as DocEdcuationResource;
use App\Http\Resources\DocWorkExperience as DocWorkExperienceResource;
use App\Http\Resources\DocDigitalPic as DocDigitalPicResource;

class DocumentsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    protected $errorMsgApp='Sorry you can not upload the documents due to application status has been changed.';
    protected $errorMsgAppOwner='This application is not belong you. Please check application ID.';
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function identity(Request $request){
        
        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/';
        if($request->hasFile('passportDoc')){
           $input['passportDoc'] = $this->common->fileUpload($request->file('passportDoc'),$path.'identity/');
        }
        if($request->hasFile('nationalId')){
           $input['nationalId'] = $this->common->fileUpload($request->file('nationalId'),$path.'identity/');
        }
        if($request->hasFile('birthCertificate')){
           $input['birthCertificate'] = $this->common->fileUpload($request->file('birthCertificate'),$path.'identity/');
        }
        if($request->hasFile('previousVisaStampPage')){
           $input['previousVisaStampPage'] = $this->common->fileUpload($request->file('previousVisaStampPage'),$path.'identity/');
        }
       
       
        $exist_record_id = $this->is_exist('docidentity',$input['applicationId']);
        if(!$exist_record_id){
            
            
            $input['user_id']=Auth::id();
            $input['application_id']=decode($input['applicationId']);
            $data = new DocIdentity($input);
            if($data->save()){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
            $data = DocIdentity::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
            
        }
        
        
    }
    
    function education(Request $request){

       
        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/education/';
        
        if($request->hasFile('twelfth')){
           $input['twelfth'] = $this->common->fileUpload($request->file('twelfth'),$path);
        }
        if($request->hasFile('graduation')){
           $input['graduation'] = $this->common->fileUpload($request->file('graduation'),$path);
        }
        if($request->hasFile('postGraduation')){
           $input['postGraduation'] = $this->common->fileUpload($request->file('postGraduation'),$path);
        }
        if($request->hasFile('masters')){
           $input['masters'] = $this->common->fileUpload($request->file('masters'),$path);
        }
        if($request->hasFile('phd')){
           $input['phd'] = $this->common->fileUpload($request->file('phd'),$path);
        }
       
        
        $exist_record_id = $this->is_exist('doceducation',$input['applicationId']);
        
        if(!$exist_record_id){
            
            $input['user_id']=Auth::id();
            $input['application_id']=decode($input['applicationId']);
            $data = new \App\Model\Api\DocEducation($input);
            if($data->save()){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
           
            $data =  \App\Model\Api\DocEducation::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
    }
    function work_experience(Request $request){
        
        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/work_experience/';
       
        if($request->hasFile('work_experience')){
           $input['work_experience'] = $this->common->fileUpload($request->file('work_experience'),$path);
        }
        if($request->hasFile('referenceLetter')){
           $input['referenceLetter'] = $this->common->fileUpload($request->file('referenceLetter'),$path);
        }
        if($request->hasFile('payStubs')){
           $input['payStubs'] = $this->common->fileUpload($request->file('payStubs'),$path);
        }
        $exist_record_id = $this->is_exist('docworkexperience',$input['applicationId']);
        if(!$exist_record_id){
            $input['user_id']=Auth::id();
            $input['application_id']=decode($input['applicationId']);
            $data = new \App\Model\Api\DocWorkExperience($input);
            if($data->save()){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
            $data =  \App\Model\Api\DocWorkExperience::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
        
    }
    
    function digital_picture(Request $request){

        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/digitalPicture/';
       
        
        if($request->hasFile('digitalPicture')){
           $input['digitalPicture'] = $this->common->fileUpload($request->file('digitalPicture'),$path);
        }
        $exist_record_id = $this->is_exist('docdigitalpic',$input['applicationId']);
        if(!$exist_record_id){
           
            $input['user_id']=Auth::id();
            $input['application_id']=decode($input['applicationId']);
            $data = new \App\Model\Api\DocDegitalPicture($input);
            if($data->save()){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
            $data =  \App\Model\Api\DocDegitalPicture::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
        
    }
    
    function cv_resume(Request $request){

       
        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/resume/';
        if($request->hasFile('resume')){
           $input['resume'] = $this->common->fileUpload($request->file('resume'),$path);
        }
        $exist_record_id = $this->is_exist('docresume',$input['applicationId']);
        if(!$exist_record_id){
            
           
            $input['user_id']=Auth::id();
            $input['application_id']=decode($input['applicationId']);
            $data = new \App\Model\Api\DocResume($input);
            if($data->save()){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
            $data =  \App\Model\Api\DocResume::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
        
    }
    
    function funds_proof(Request $request){

        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/fundproof/';
        
        if($request->hasFile('fundProof')){
           $input['fundProof'] = $this->common->fileUpload($request->file('fundProof'),$path);
        }
        $exist_record_id = $this->is_exist('docfundsproof',$input['applicationId']);
        if(!$exist_record_id){
           
             $input['user_id']=Auth::id();
             $input['application_id']=decode($input['applicationId']);
             $data = new \App\Model\Api\DocFundProof($input);
             if($data->save()){
                 return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
             }else{
                  return response()->json(['error'=>'Error, Please try after some time.'], 401);
             }
        }else{
            $data =  \App\Model\Api\DocFundProof::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
    }
    
    function ca_report(Request $request){

        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/careport/';
       
        
        if($request->hasFile('caReport')){
           $input['caReport'] = $this->common->fileUpload($request->file('caReport'),$path);
        }
        
        $exist_record_id = $this->is_exist('doccareport',$input['applicationId']);
        if(!$exist_record_id){
           
            $input['user_id']=Auth::id();
            $input['application_id']=decode($input['applicationId']);
            $data = new \App\Model\Api\DocCaReport($input);
            if($data->save()){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }else{
            $data =  \App\Model\Api\DocCaReport::find($exist_record_id);
            if($data->update($input)){
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
        
    }
    
    function business_doc(Request $request){

        
        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/business/';
        
        
        $input['businessDoc']='';
        $input = $request->all();
        $input['application_id']=decode($input['applicationId']);
        
        $files = array();
        if($request->hasFile('businessDoc')){
            for($i=0;$i<count($input['businessDoc']);$i++){
                $files[] = $this->common->fileUpload($input['businessDoc'][$i],$path);
            }
            if(!empty($files)){
                //$input['businessDoc'] = json_encode($files);
            }

        }
        $exist_record_id = $this->is_exist('docbusiness',$input['applicationId']);
        
           
            $input['user_id']=Auth::id();
            //echo "<pre>"; print_r($input); echo "</pre>"; die();
            
            if(!empty($files)){
                foreach($files as $f){
                    $input['businessDoc'] = $f;
                    $data = new \App\Model\Api\DocBusiness($input);
                    $data->save();
                }
                return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
            }else{
                return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
            
            
        
        
        
        
    }
    
    function others_doc(Request $request){

        
        $validator = Validator::make($request->all(), [
            'applicationId' => 'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        if($this->common->isApplicaitonYour($request->input('applicationId'),Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($request->input('applicationId'))){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $input['otherDoc']='';
        $input = $request->all();
        $path = 'uploads/document/'.$input['applicationId'].'/others/';
        
        $input['application_id']=decode($input['applicationId']);
        $files = array();
        if($request->hasFile('otherDoc')){
            for($i=0;$i<count($input['otherDoc']);$i++){
                $files[] = $this->common->fileUpload($input['otherDoc'][$i],$path);
            }
            
           
        }
        //$exist_record_id = $this->is_exist('docothers',$input['applicationId']);
        $input['user_id']=Auth::id();
        if(!empty($files)){
            foreach($files as $f){
                $input['otherDoc'] = $f;
                $data = new \App\Model\Api\DocOther($input);
                $data->save();
            }
            return response()->json(['success'=>"Document has been uploaded successfully"], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
        
    }
    
    function message_errors(){
        return [
            'applicationId.required'=> 'Valid Application ID is required',
        ];
    }
    
    function is_exist($table='',$applicaiton_id = ''){
        return  $this->common->getRecordByField($table, array("user_id"=>Auth::id(),'application_id'=>  decode($applicaiton_id)),'id');
    }
    
    /*Assigned Documents*/
    public function showDocByStudent(){
        
        $list['data'] =  DocumentsAssignResource::collection(DocumentsAssign::with(['doc'],['assigner'],['user'])->where('studentID',  Auth::id())->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
}
