<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class DocFundProof extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            $this->mergeWhen(Auth::user()->isCompany(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            'fundProof'=>asset("uploads/document/".encode($this->application_id)."/fundproof/". $this->fundProof),
            'fundProofFile'=>$this->fundProof,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
