<?php

namespace App\Http\Controllers\Api\Manager;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\User;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;



class StudentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    function create(Request $request){


        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email',
            'phone' => 'required',
            'sex' => 'in:Male,Female',
            'martialStatus' => 'in:Married,Single,Divorce',
            //'agent_id' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        if(userEmailExist($request->input('email'))){
            return response()->json(['error'=>"Email Already exist"], 401);
        }
        if(userPhoneExist($request->input('phone'))){
            return response()->json(['error'=>"Phone number Already exist"], 401);
        }

        $input = $request->all();

        $input['password'] = Hash::make($input['password']);



        if($request->has('agent_id')&& $request->input('agent_id')!=""){


            $is_agent = User::where('id',  decode($input['agent_id']))->where('role',3)->count();
            if(!$is_agent){
                return response()->json(['error'=>"Invalid agent id"], 401);
            }

            $input['agent_id'] = decode($input['agent_id']);
        }else{
           $input['agent_id']=0;
        }
        $input['role'] = 4;
        $input['status'] = 1;
        $input['owner_key']=secret_key_get();
        //echo "<pre>"; print_r($input); echo "</pre>"; die();
        $user = User::create($input);
        $success['Authorization'] =  $user->createToken('MyApp')->accessToken;
        $success['name'] =  $user->name;
        $success['role'] = "Student";
        $success['status'] = "Active";
        $success['student_id'] = encode($user->id);


        return response()->json(['success'=>$success], $this->successStatus);

    }
    public function show(Request $request){

        $query = User::where('owner_key',secret_key_get())->where('role',4);


        if($request->has('FirstName') && $request->get('FirstName') !=""){
            $query->where('name',  $request->get('FirstName'));
        }
        if($request->has('LastName') && $request->get('LastName') !=""){
            $query->where('last_name',  $request->get('LastName'));
        }
        if($request->has('phone') && $request->get('phone') !=""){
            $query->where('phone', 'like', '%'.$request->get('phone').'%');
        }
        if($request->has('email') && $request->get('email') !=""){
            $query->whereRaw('LOWER(email) like ?',strtolower($request->get('email')));
        }
        if($request->has('status') && $request->get('status') !=""){
            $query->where('status',  $request->get('status'));
        }
        if($request->has('zipcode') && $request->get('zipcode') !=""){
            $query->where('zipcode',  $request->get('zipcode'));
        }
        if($request->has('agent') && $request->get('agent') !=""){
            $query->where('agent_id',  decode($request->get('agent')));
        }


        if($request->get('page')){
            $list =  UserResource::collection($query->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
           $list['data'] =  UserResource::collection($query->get());
        }
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function single($id=0){
        $id = decode($id);
        $single['data'] =  UserResource::collection(User::where('owner_key',secret_key_get())->where('id',$id)->where('role',4)->get());
        return response()->json(['success'=>$single], $this->successStatus);
    }

    public function edit(Request $request,$id){
        //echo "<pre>"; print_r($request->all()); echo "</pre>"; die();
        $ecodeId = $id;
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email',
            'phone' => 'required',
            'sex' => 'in:Male,Female',
            'martialStatus' => 'in:Married,Single,Divorce',
            //'agent_id' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        if(userEmailExist($request->input('email'),  $ecodeId)){
            return response()->json(['error'=>array(array("Email Already exist"))], 401);
        }
        if(userPhoneExist($request->input('phone'),  $ecodeId)){
            return response()->json(['error'=>array(array("Phone number Already exist"))], 401);
        }


        $form_data = $request->all();
        // echo "<pre>"; print_r($form_data); echo "</pre>"; die();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }


        if($request->has('agent_id')&& $request->input('agent_id')!=""){
           $form_data['agent_id'] = decode($form_data['agent_id']);
        }else{
           $form_data['agent_id']=0;
        }

        if(!$request->has('placeBirth')){
            $form_data['placeBirth'] = '';
        }

        if(!$request->has('phone')){
            $form_data['phone'] = '';
        }

        if(!$request->has('anotherPhone')){
            $form_data['anotherPhone'] = '';
        }
        if(!$request->has('passportNumber')){
            $form_data['passportNumber'] = '';
        }
        if(!$request->has('nativeLanguage')){
            $form_data['nativeLanguage'] = '';
        }
        if(!$request->has('citizenship')){
            $form_data['citizenship'] = '';
        }

        if(!$request->has('address')){
            $form_data['address'] = '';
        }

        if(!$request->has('city')){
            $form_data['city'] = '';
        }
        if(!$request->has('state')){
            $form_data['state'] = '';
        }
        if(!$request->has('district')){
            $form_data['district'] = '';
        }
        if(!$request->has('zipcode')){
            $form_data['zipcode'] = '';
        }
        if(!$request->has('country')){
            $form_data['country'] = '';
        }

        $data = User::find($id);
        if($data->update($form_data)){
            return response()->json(['success'=>'Record has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function delete($id){
        $id = decode($id);

        $delete=  User::where("id",$id)->delete();
        if($delete){
            $this->related_record_remove($id);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function related_record_remove($id){

        $retrainer = \App\Model\Api\RetrainerAgreement::where('studentID',$id)->delete();
        $assignDoc = \App\Model\Api\DocumentsAssign::where('studentID',$id)->delete();
        $notes = \App\Model\Api\Notes::where('postTo',$id)->delete();
        $notification = \App\Model\Api\Notification::where('from_id',$id)->delete();
        $notification2 = \App\Model\Api\Notification::where('to_id',$id)->delete();

        $this->common->studentApiDocDeleteAll($id);


    }
    function document_delete(){

    }
    function message_errors(){
        return [
            'name.required'=> 'Name should not be blank',
            'agent_id.required'=> 'Agent ID required',
            'name.max'=> 'Name should not be greated than 255 characters',
            'email.unique'=>'Email already exist',
            'email.email'=>'Invalid Email',
            'phone.unique'=>'Phone number already exist',
            'phone.required'=>'Invalid Phone',
            'password.min'=>"Minimu 6 chracters",
            'sex.in' => "Value should be [Male,Female]",
            'martialStatus.in'=>'Value should be [Married,Single,Divorce]',
        ];
    }

}
