<?php

namespace App\Http\Controllers\Api\Student;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\DocIdentity;
use Validator;
use Illuminate\Support\Facades\Hash;

use App\Http\Resources\DocIdentity as DocIdentityResource;
use App\Http\Resources\DocEdcuation as DocEdcuationResource;
use App\Http\Resources\DocWorkExperience as DocWorkExperienceResource;
use App\Http\Resources\DocDigitalPic as DocDigitalPicResource;

use App\Http\Resources\DocResume as DocResumeResource;
use App\Http\Resources\DocFundProof as FundProofResource;
use App\Http\Resources\DocCaReport as DocCaReportResource;
use App\Http\Resources\DocBiz as DocBizResource;
use App\Http\Resources\DocOther as DocOtherResource;

class DocumentsViewController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    protected $errorMsgApp='Sorry you can not upload the documents due to application status has been changed.';
    protected $errorMsgAppOwner='This application is not belong you. Please check application ID.';
    
    public function __construct(){  
        $this->common=new CommonController();
    }

    public function identity($applicationID = 0){
        $list['data'] =  DocIdentityResource::collection(DocIdentity::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function education($applicationID = 0){
        $list['data'] =  DocEdcuationResource::collection(\App\Model\Api\DocEducation::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function work_experience($applicationID = 0){
        $list['data'] =  DocWorkExperienceResource::collection(\App\Model\Api\DocWorkExperience::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function digital_picture($applicationID = 0){
        $list['data'] =  DocDigitalPicResource::collection(\App\Model\Api\DocDegitalPicture::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function cv_resume($applicationID = 0){
        $list['data'] =  DocResumeResource::collection(\App\Model\Api\DocResume::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function funds_proof($applicationID = 0){
        $list['data'] =  FundProofResource::collection(\App\Model\Api\DocFundProof::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function ca_report($applicationID = 0){
        $list['data'] =  DocCaReportResource::collection(\App\Model\Api\DocCaReport::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function business_doc($applicationID = 0){
        $list['data'] =  DocBizResource::collection(\App\Model\Api\DocBusiness::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function others_doc($applicationID = 0){
        $list['data'] =  DocOtherResource::collection(\App\Model\Api\DocOther::where('user_id',Auth::id())->where('application_id',  decode($applicationID))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    /*Document Delete*/
    
    
    public function identity_delete($id=0,$applicationID = 0,$field=''){
        $id = decode($id);
        
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $file =  $this->common->getRecordByField("docidentity",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        
        $data = \App\Model\Api\DocIdentity::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/identity/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function education_delete($id=0,$applicationID = 0,$field=''){
        $id = decode($id);
        
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        
        $file =  $this->common->getRecordByField("doceducation",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocEducation::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/education/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function work_experience_delete($id=0,$applicationID = 0,$field=''){
        
        $id = decode($id);
        
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("docworkexperience",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocWorkExperience::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/work_experience/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function digital_picture_delete($id=0,$applicationID = 0,$field=''){
        
        $id = decode($id);
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("docdigitalpic",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocDegitalPicture::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/digitalPicture/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function cv_resume_delete($id=0,$applicationID = 0,$field=''){
       
        $id = decode($id);
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("docresume",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocResume::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/resume/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function funds_proof_delete($id=0,$applicationID = 0,$field=''){
        
        $id = decode($id);
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("docfundsproof",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocFundProof::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/fundproof/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function ca_report_delete($id=0,$applicationID = 0,$field=''){
        
        $id = decode($id);
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("doccareport",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocCaReport::find($id);
        $data->$field ='';
        if($data->save()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/careport/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function business_doc_delete($id=0,$applicationID = 0,$field=''){
        
        $id = decode($id);
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("docbusiness",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocBusiness::find($id);
        if($data->delete()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/business/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    public function others_doc_delete($id=0,$applicationID = 0,$field=''){
       
        $id = decode($id);
        if($this->common->isApplicaitonYour($applicationID,Auth::id())){
            return response()->json(['error'=>$this->errorMsgAppOwner], 401); 
        }
        if($this->common->docApplicationStatus($applicationID)){
            return response()->json(['error'=>$this->errorMsgApp], 401); 
        }
        $file =  $this->common->getRecordByField("docothers",array("id"=>$id,'application_id'=>decode($applicationID)),$field); 
        $data =  \App\Model\Api\DocOther::find($id);
        if($data->delete()){
            $this->common->fileDel('uploads/document/'.$applicationID.'/others/'.$file);
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    
}
