<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\User;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;



class BulkDataSaveController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    function student_create(Request $request){
        
       
       $validator = Validator::make($request->all(), [
            'studentData' => 'required',
        ],  $this->message_errors());
        
        $data = $request->input('studentData');;
        
        $result = json_decode($data, true);
       
        
        if(empty($result)){
            return response()->json(['error'=>$validator->errors()], 400);        
        }
       
        $index=0;
        $errors = array();
        $recordSuccess =  array();
        foreach($result as $r){
            $dataError = array();
            
            if(userEmailExist($r['email'])){
                $dataError[$r['recordId']]['email'] = "Already exist"; 
            }
            if(userPhoneExist($r['phone'])){
                
                $dataError[$r['recordId']]['phone'] = "Already exist"; 
            }
            
            if(!empty($dataError)){
                $errors[] = $dataError;
            }else{
                
                
                $input['name'] = $r['name'];
                $input['last_name'] = $r['last_name'];
                $input['sex'] = $r['sex'];
                $input['placeBirth'] = $r['placeBirth'];
                $input['email'] = $r['email'];
                $input['phone'] = $r['phone'];
                $input['password'] = Hash::make('generate_system');
                $input['dateOfbirth'] = $r['dateOfbirth'];
                
                if(Auth::user()->role == 3){
                    $input['agent_id'] = Auth::id();
                }else{
                    
                    if($request->has('agent_id')&& $request->input('agent_id')!=""){

                        $input['agent_id'] = decode($request->input('agent_id'));
                    }else{
                       $input['agent_id']=0; 
                    }
                }
                
                
                
                
                $input['role'] = 4;
                $input['status'] = 1;
                $input['owner_key']=secret_key_get();
                $user = User::create($input);
                $recordSuccess[] = $r['recordId'];
                
            }
            
            
            $index++;
        }
        return response()->json(['success'=>$recordSuccess,'error'=>$errors], $this->successStatus);
    }
    
    function studentFieldExist($field,$value){
        $student = User::where($field,$value)->where('')->count();
        return $student;
    }
    
    function lead_create(Request $request){
        
       
       $validator = Validator::make($request->all(), [
            'leadData' => 'required',
        ],  $this->message_errors());
        
        $data = $request->input('leadData');;
        
        $result = json_decode($data, true);
       
        
        if(empty($result)){
            return response()->json(['error'=>$validator->errors()], 400);        
        }
       
        $index=0;
        $errors = array();
        $recordSuccess =  array();
        
        foreach($result as $r){
            $dataError = array();
            
            if(userEmailExist($r['email'])){
                $dataError[$r['recordId']]['email'] = "This email already register as Client"; 
            }
            if(userPhoneExist($r['phone'])){
                
                $dataError[$r['recordId']]['phone'] = "This phone number already register as client"; 
            }
            
            if(getLeadEmailExist($r['email'])){
                $dataError[$r['recordId']]['emailLead'] = "This email already register in Lead"; 
            }
            if(getLeadPhoneExist($r['phone'])){
                $dataError[$r['recordId']]['phoneLead'] = "This phone number already register in Lead"; 
            }
            
            if(!empty($dataError)){
                $errors[] = $dataError;
            }else{
                
                
                $input['firstName'] = $r['name'];
                $input['lastName'] = $r['last_name'];
                $input['phoneNumber'] = $r['phone'];
                $input['email'] = $r['email']; 
                $input['dob'] = $r['dateOfbirth'];
                $input['city'] = $r['city'];
                $input['openBy'] =  Auth::id();
                $input['status'] = 'New';
                $input['administer_id'] =  ownerKeyId(secret_key_get());
                
                $lead = \App\Model\Api\Leads::create($input);
                if($lead){
                    $commIdObj = \App\Model\Api\Leads::find($lead->id);
                    $commId = rand(1, 10).$lead->id.rand(1, 10);
                    $commIdObj->leadUnique_id = $commId;
                    $commIdObj->save();
                }
                $recordSuccess[] = $r['recordId'];
                
            }
            
            
            $index++;
        }
        return response()->json(['success'=>$recordSuccess,'error'=>$errors], $this->successStatus);
    }
    
    
    function message_errors(){
        return [
            'studentData.required'=> 'Student data can not be not be blank',
            
        ];
    }
    
    
}
