<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, SparkPost and others. This file provides a sane default
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'sparkpost' => [
        'secret' => env('SPARKPOST_SECRET'),
    ],
    
//    'stripe' => [
//        'model' => App\User::class,
//        'key' =>'pk_test_51H5OhyEkJbHUhoXjAxhjpGIqERfVYc9V7Lkscgbdezwvqfe1HZmcP2kVhBa8j8tGwOR2Ue0gCkSLhFJGrbGyUiqh00NRkIOYkC',
//        'secret' => 'sk_test_51H5OhyEkJbHUhoXjpJ5rYoyMJk48zQACqcUPwnxec1o5Yq6BNJj2em0vgrhijEflLQfcyseQi02KZNexjWtlqwXB00eKg88dIv',
//    ],
    'stripe' => [
        'model'  => 'App\Models\User',
        'key'    => env('STRIPE_KEY'),
        'secret' => env('STRIPE_SECRET'),
    ],

];
