@extends('layouts.default')
@section('title','Package - Manage')
@section('header_extra')
<!-- DataTables -->
<link href="{{asset('assets/plugins/datatables/dataTables.bootstrap4.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{asset('assets/plugins/datatables/buttons.bootstrap4.min.css')}}" rel="stylesheet" type="text/css" />
<!-- Responsive datatable examples -->
<link href="{{asset('assets/plugins/datatables/responsive.bootstrap4.min.css')}}" rel="stylesheet" type="text/css" />

<link href="{{ asset('assets/plugins/sweet-alert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css">
@stop
@section('content')
 <div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <h4 class="m-t-0 mb-1 header-title"><b>Manage</b></h4>
            
            <div class="row">
                <div class="col-12 mb-3">
                    <div class="text-right">
                        <a href="{{route('admin.package.add_new')}}" class="btn btn-success"><i class="fa fa-plus"></i> Add new</a>
                    </div>
                </div>
            </div>
            
            @include('widget/notifications')
            <table id="datatable-inline" class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Days</th>
                        <th>Price</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
 </div>
@stop


@section('footer_scripts')
<script src="{{asset('assets/plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/plugins/datatables/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('assets/plugins/datatables/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('assets/plugins/datatables/responsive.bootstrap4.min.js')}}"></script>


<script src="{{ asset('assets/plugins/sweet-alert2/sweetalert2.min.js') }}"></script>
<script src="{{ asset('assets/plugins/sweet-alert2/jquery.sweet-alert2.init.js') }}"></script>

<script type="text/javascript">
    $(document).ready(function() {
       
       var table = $('#datatable-inline').DataTable({
            processing: true,
            serverSide: true,
            "pageLength": 25,            
            ajax: {
                url:'{!! route('admin.package.showAjaxList') !!}',
            },
            columns: [                
                { data: 'id', name: 'id' }, 
                { data: 'name', name: 'name' },
                { data: 'days', name: 'days' },
                { data: 'grand', name: 'grand' }, 
                { data: 'status', name: 'status',orderable: false, searchable: false },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            "order": [[ 0, "desc" ]]
        });
        $(function(){
            $(this).active_menu("subscription");
        });
    });
</script>
@stop

