@extends('layouts.default')
@section('title','Packages')
@section('header_extra')

@stop
@section('content')
 <div class="row">
    <div class="col-12">
        
        <div class="row">
            <div class="col-lg-9 center-page">
                <div class="text-center">
                    @include('widget/notifications')
                    <h3 class="m-b-30 m-t-20">Choose your perfect subscriptions</h3>
                    
                </div>

                <div class="row m-t-50">

                    @if(!empty($r))   
                    
                        <article class="pricing-column col-md-4 mx-auto">
                            <div class="inner-box card-box">
                                @if(is_subscribe($r->name))
                                <div class="ribbon-pricing"><span>Current Subscription</span></div>
                                @endif
                                <div class="plan-header text-center">
                                    <h3 class="plan-title">{{$r->name}}</h3>
                                    <h2 class="plan-price">${{$r->price}}</h2>
                                    <div class="plan-duration">{{$r->duration}}</div>
                                </div>
                                {!! $r->description !!}

                                <div class="text-center">
                                    @if(!is_subscribe($r->name))
                                    <a href="javascript:void(0)" class="btn btn-success btn-bordered w-lg btn-md w-md btn-bordred btn-rounded waves-effect waves-light">Buy Now</a>
                                    @else
                                    <button href="javascript:void(0);" class="btn btn-success w-lg btn-md w-md btn-bordred btn-rounded waves-effect waves-light" disabled="">Buy Now</button>
                                    @endif
                                </div>
                            </div>
                        </article>
                    
                    @endif


                    <div class="col-12">
                        <a href="{{route('admin.package.manage')}}" class="btn btn-primary">Back</a>
                    </div>
                </div>
            </div><!-- end col -->
        </div>
    </div>
 </div>
@stop


@section('footer_scripts')


<script type="text/javascript">
    $(document).ready(function() {
        $(function(){
            $(this).active_menu("subscription");
        });
    });
</script>
@stop

