@extends('layouts.default')
@section('title','My Profile')
@section('header_extra')
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <div class="profile-bg-picture">
            <span class="picture-bg-overlay"></span><!-- overlay -->
        </div>
        <!-- meta -->
        <div class="profile-user-box">
            <div class="row">
                <div class="col-sm-6">
                    <span class="pull-left m-r-15">
                        @if($r->picture!="")
                        <img src="{{asset('uploads/profile/'.$r->picture)}}" alt="" class="thumb-lg rounded-circle">
                        @endif
                    </span>
                    <div class="media-body">
                        <h4 class="m-t-5 m-b-5 font-18 ellipsis">{{$r->name.' '.$r->last_name}}</h4>
                        <p class="font-13"> Admin</p>
                        <p class="text-muted m-b-0"><small>{{$r->state. ' '.$r->country}}</small></p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="text-right">
                        <a href="{{route('admin.profile_edit')}}" class="btn btn-success waves-effect waves-light">
                            <i class="mdi mdi-account-settings-variant m-r-5"></i> Edit Profile
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--/ meta -->
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <!-- Personal-Information -->
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Personal Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Full Name :</strong> <span class="m-l-15">{{$r->name.' '.$r->last_name}}</span></p>

                    <p class="text-muted font-13"><strong>Mobile :</strong><span class="m-l-15">{{$r->phone}}</span></p>

                    <p class="text-muted font-13"><strong>Email :</strong> <span class="m-l-15">{{$r->email}}</span></p>

                    <p class="text-muted font-13"><strong>Address :</strong> <span class="m-l-15">{{$r->address}}</span></p>

                    <p class="text-muted font-13"><strong>City :</strong> <span class="m-l-15">{{$r->city}}</span></p>
                    <p class="text-muted font-13"><strong>Province :</strong> <span class="m-l-15">{{$r->state}}</span></p>
                    <p class="text-muted font-13"><strong>Country :</strong> <span class="m-l-15">{{$r->country}}</span></p>
                    <p class="text-muted font-13"><strong>Postal :</strong> <span class="m-l-15">{{$r->zipcode}}</span></p>
                    <p class="text-muted font-13"><strong>Status :</strong> 
                        <span class="m-l-15">
                            @if($r->status == "1")
                            <span class="label label-success">Active</span>
                            @elseif($r->status == "0")
                            <span class="label label-danger">Disable</span>
                            @endif
                            
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <!-- Personal-Information -->

        

    </div>


    
    <!-- end col -->

</div>





@endsection

@section('footer_scripts')
@stop