@extends('layouts.default')
@section('title','Customer - Manage')
@section('header_extra')
<!-- DataTables -->
<link href="{{asset('assets/plugins/datatables/dataTables.bootstrap4.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{asset('assets/plugins/datatables/buttons.bootstrap4.min.css')}}" rel="stylesheet" type="text/css" />
<!-- Responsive datatable examples -->
<link href="{{asset('assets/plugins/datatables/responsive.bootstrap4.min.css')}}" rel="stylesheet" type="text/css" />
@stop


@section('content')



 <div class="row">
    <div class="col-12">
        <div class="card-box table-responsive">
            <h4 class="m-t-0 mb-5 header-title"><b>Manage</b></h4>
            
            <div class="row">
                <div class="col-12 mb-3">
                    <div class="text-right">
                        <a target="_blank" href="{{route('admin.user.export')}}" class="btn btn-success"><i class="fa fa-download"></i> Export User</a>
                    </div>
                </div>
            </div>
            
            
            @include('widget/notifications')
            <table id="datatable-inline" class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Zip Code</th>
                        <th>Subscribed</th>
                        <th>Status</th>
                        <th>View</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
 </div>
@stop


@section('footer_scripts')
<script src="{{asset('assets/plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/plugins/datatables/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('assets/plugins/datatables/dataTables.responsive.min.js')}}"></script>
<script src="{{asset('assets/plugins/datatables/responsive.bootstrap4.min.js')}}"></script>

<script type="text/javascript">
    $(document).ready(function() {
       
       var table = $('#datatable-inline').DataTable({
            processing: true,
            serverSide: true,
            "pageLength": 25,            
            ajax: {
                url:'{!! route('admin.user.showAjaxList') !!}',
                 data:function(d){                    
                  d.filterextend = $('#verified').val();
               }
            },
            columns: [                
                { data: 'id', name: 'id' }, 
                { data: 'name', name: 'name' },
                { data: 'last_name', name: 'last_name' },
                { data: 'email', name: 'email' },
                { data: 'phone', name: 'phone' },
                { data: 'zipcode', name: 'zipcode' },                             
                { data: 'subscribe_date', name: 'subscribe_date',orderable: false, searchable: false }, 
                { data: 'status', name: 'status',orderable: false, searchable: false },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            "order": [[ 0, "desc" ]]
        });
        
        
        $('<label style="margin-left: 20px;">Search by verified ' +
        '<select class="form-control input-sm" id="verified" style="width:100px;">'+
            '<option value="">All</option>'+
            '<option value="1">Active</option>'+
            '<option value="0">De-Active</option> '+            
        '</select>' + 
        '</label>').appendTo("#datatable-inline_wrapper #datatable-inline_length");
        
        $("body").on("change","#verified",function(){
            $('#datatable-inline').DataTable().draw();
        });
        
        $(function(){
            $(this).active_menu("customer");
        });
    });
</script>
@stop

