@extends('layouts.default')
@section('title','My Profile - Edit')
@section('header_extra')
@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Profile Edit</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        @include('widget/notifications')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form class="form-horizontal validate" action="{{route('customer.profile_update')}}" method="post" role="form" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" id="rid" value="{{Auth::id()}}">
                            <div class="form-group row">
                                <label class="col-2 col-form-label">First Name <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="name" class="form-control" required value="{{$r->name}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Last Name </label>
                                <div class="col-8">
                                    <input type="text" name="last_name" class="form-control"  value="{{$r->last_name}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Phone <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="phone" required="" class="form-control" value="{{$r->phone}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Address <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="address" class="form-control" required value="{{$r->address}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Company Name <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="company_name" class="form-control" required value="{{$r->company_name}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Web site</label>
                                <div class="col-8">
                                    <input type="text" name="website" class="form-control" value="{{$r->website}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Company Email</label>
                                <div class="col-8">
                                    <input type="email" name="company_email" class="form-control" value="{{$r->company_email}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Company Phone Number</label>
                                <div class="col-8">
                                    <input type="text" name="company_phone" class="form-control" value="{{$r->company_phone}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Number of employee</label>
                                <div class="col-8">
                                    <input type="text" name="number_employee" class="form-control" value="{{$r->number_employee}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Privacy Policy Link</label>
                                <div class="col-8">
                                    <input type="text" name="privacy_policy_link" class="form-control" value="{{$r->privacy_policy_link}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">City</label>
                                <div class="col-8">
                                    <input type="text" name="city" class="form-control" value="{{$r->city}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Province</label>
                                <div class="col-8">
                                    <input type="text" name="state" class="form-control" required value="{{$r->state}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Country <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <select name="country" class="form-control" required>
                                        <option value="">Select Country</option>
                                        @if(!empty($country))
                                        @foreach($country as $c)
                                        <option  value="{{$c->iso}}" {{($c->iso == $r->country ? "selected":"")}}>{{$c->nicename}}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                    
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Postal <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="zipcode" class="form-control" required value="{{$r->zipcode}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Picture </label>
                                <div class="col-8">
                                    <input type="file" name="picture" class="form-control"  >
                                </div>
                            </div>
                            @if($r->picture)
                            <div class="form-group row">
                                <label class="col-2 col-form-label">&nbsp; </label>
                                <div class="col-8">
                                    <img src="{{asset('uploads/profile/'.$r->picture)}}" class="thumb-xl">
                                </div>
                            </div>
                            @endif
                            
                            
                            <div class="form-group row {{ $errors->has('email') ? ' has-danger' : '' }}">
                                <label class="col-2 col-form-label">Email <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="email" name="email" class="form-control" required value="{{$r->email}}" id="useremail">
                                    <ul id="parsley-id-5" class="parsley-errors-list filled useremail_exist" style="display: none;">
                                        <li class="parsley-required"> Email Already Exist</li>
                                    </ul>  
                                    @if ($errors->has('email'))
                                        <div class="form-control-feedback">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="form-group row ">
                                <label class="col-2 col-form-label">Current Password </label>
                                <div class="col-8">
                                    <input type="password" name="current_password" class="form-control " >
                                </div>
                                
                            </div>
                            
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">New Password </label>
                                <div class="col-8">
                                    <input type="password" name="new_password" class="form-control" >
                                </div>
                            </div>
                            
                            <div class="form-group row ">
                                <label class="col-2 col-form-label">Confirm Password </label>
                                <div class="col-8">
                                    <input type="password" name="password_confirmation" class="form-control" >
                                </div>
                                
                            </div>
                            
                            
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript" src="{{asset('assets/plugins/parsleyjs/parsley.min.js')}}"></script>
<script type="text/javascript" src="{{asset('assets/js/custom.js')}}"></script>
<script type="text/javascript">
    $(function(){
        $(this).active_menu("profile");
    })
    
</script>
@stop