<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'v1','middleware' => ['keycheck']], function () {



        //Auth
        Route::post('login',['as'=>"login",'uses'=>"Api\AuthController@login"]);
        Route::post('register',['as'=>"register",'uses'=>"Api\AuthController@register"]);

        //Cron Job
        Route::get('users', [ 'uses'=>'Api\CronController@users']);
        Route::get('application-cron', [ 'uses'=>'Api\CronController@application']);
        Route::get('interaction', [ 'uses'=>'Api\CronController@interaction']);
        Route::get('lead', [ 'uses'=>'Api\CronController@lead']);
        Route::post('password-reset',['as'=>"password_reset",'uses'=>"Api\AuthController@password_reset"]);

        /*Email check exist*/
        Route::post('user-field-check', [ 'uses'=>'Api\CronController@fieldExist']);


        /*Common Auth*/
        Route::group(['middleware'=>['auth:api']], function () {
            Route::post('logout',['as'=>"logout",'middleware'=>['auth:api'],'uses'=>"Api\AuthController@logout"]);
            Route::get('my-profile', ['uses'=>'Api\HomeController@show']);
            Route::put('edit-profile', ['uses'=>'Api\HomeController@edit']);

            Route::get('get-register-email/{id}', ['uses'=>'Api\HomeController@getEmailid']);

            Route::group(['prefix' => 'notifications'], function () {
                Route::post('create', [ 'uses'=>'Api\NotificationController@create']);
                Route::get('list', [ 'uses'=>'Api\NotificationController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\NotificationController@single']);
                Route::post('status/{id}', [ 'uses'=>'Api\NotificationController@status']);
            });

        });



        /*Admin*/
        Route::group(['prefix' => 'admin', 'as' => 'admin.','middleware'=>['auth:api','api.admin']], function () {
            Route::get('user',function(Request $request){
                return $request->user();
            });
            Route::post('search', [ 'uses'=>'Api\SearchController@show']);

            Route::group(['prefix' => 'today-task', 'as' => 'today_task.'], function () {
                Route::post('create', [ 'uses'=>'Api\TodaytaskController@create']);
                Route::get('list', ['uses'=>'Api\TodaytaskController@show']);
                Route::post('update/{id}', ['uses'=>'Api\TodaytaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TodaytaskController@single']);
                Route::get('delete/{id}', [ 'uses'=>'Api\TodaytaskController@delete']);
            });
            Route::group(['prefix' => 'manager', 'as' => 'manager.'], function () {
                Route::post('create', [ 'uses'=>'Api\Admin\ManagerController@create']);
                Route::get('list', ['uses'=>'Api\Admin\ManagerController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Admin\ManagerController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\Admin\ManagerController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\ManagerController@delete']);
            });
            Route::group(['prefix' => 'staff', 'as' => 'staff.'], function () {
                Route::post('create', [ 'uses'=>'Api\Admin\StaffController@create']);
                Route::get('list', ['uses'=>'Api\Admin\StaffController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Admin\StaffController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\Admin\StaffController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\StaffController@delete']);
            });
            Route::group(['prefix' => 'associate', 'as' => 'associate.'], function () {
                Route::post('create', [ 'uses'=>'Api\Admin\AssociateController@create']);
                Route::get('list', ['uses'=>'Api\Admin\AssociateController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Admin\AssociateController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\Admin\AssociateController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\AssociateController@delete']);
                Route::get('task/{id}', ['uses'=>'Api\Admin\AssociateController@task']);
            });
            Route::group(['prefix' => 'agent', 'as' => 'agent.'], function () {
                Route::post('create', ['as'=>'register_agent', 'uses'=>'Api\Admin\AgentController@create']);
                Route::get('list', ['as'=>'register_agent', 'uses'=>'Api\Admin\AgentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Admin\AgentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Admin\AgentController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\AgentController@delete']);
                Route::get('task/{id}', ['uses'=>'Api\Admin\AgentController@task']);
            });

            Route::group(['prefix' => 'student', 'as' => 'student.'], function () {
                Route::post('create', [ 'uses'=>'Api\Admin\StudentController@create']);
                Route::get('list', ['uses'=>'Api\Admin\StudentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Admin\StudentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Admin\StudentController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\StudentController@delete']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@student_create']);
            });

            Route::group(['prefix' => 'instructions'], function () {
                Route::post('create', [ 'uses'=>'Api\Admin\InstructionController@create']);
                Route::get('list', [ 'uses'=>'Api\Admin\InstructionController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\InstructionController@delete']);
            });

            Route::group(['prefix' => 'set-documents'], function () {
                Route::post('create', [ 'uses'=>'Api\Admin\DocumentsController@create']);
                Route::post('list', ['uses'=>'Api\Admin\DocumentsController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\DocumentsController@delete']);

                Route::post('assign-student', [ 'uses'=>'Api\Admin\DocumentsController@assign']);
                Route::post('assign-student-list', [ 'uses'=>'Api\Admin\DocumentsController@showDocByStudent']);
                Route::delete('assign-delete/{id}', [ 'uses'=>'Api\Admin\DocumentsController@delete_assign']);
            });

            Route::group(['prefix' => 'retrainer-agreement'], function () {
                Route::post('create', ['uses'=>'Api\Admin\RetrainerAgreementController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\Admin\RetrainerAgreementController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\RetrainerAgreementController@delete']);
            });

            Route::group(['prefix' => 'calender'], function () {
                Route::post('create', ['uses'=>'Api\CalenderController@create']);
                Route::get('list', ['uses'=>'Api\CalenderController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\CalenderController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\CalenderController@update']);
                Route::get('single/{id}', ['uses'=>'Api\CalenderController@single']);
            });

            Route::group(['prefix' => 'tasks'], function () {
                Route::post('create', ['uses'=>'Api\TaskController@create']);
                Route::get('list', ['uses'=>'Api\TaskController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\TaskController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\TaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TaskController@single']);
            });
            Route::group(['prefix' => 'notes'], function () {
                Route::post('create', ['uses'=>'Api\Admin\NotesController@create']);
                Route::get('list', ['uses'=>'Api\Admin\NotesController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\Admin\NotesController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Admin\NotesController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\Admin\NotesController@update']);
            });

            Route::group(['prefix' => 'notes-system'], function () {
                Route::post('create', ['uses'=>'Api\NotesAdminController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\NotesAdminController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\NotesAdminController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\NotesAdminController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\NotesAdminController@update']);
            });

            Route::group(['prefix' => 'documents'], function () {
                Route::post('identity', ['uses'=>'Api\DocumentsController@identity']);
                Route::post('education', ['uses'=>'Api\DocumentsController@education']);
                Route::post('work-experience', ['uses'=>'Api\DocumentsController@work_experience']);
                Route::post('digital-picture', ['uses'=>'Api\DocumentsController@digital_picture']);
                Route::post('cv-resume', ['uses'=>'Api\DocumentsController@cv_resume']);
                Route::post('funds-proof', ['uses'=>'Api\DocumentsController@funds_proof']);
                Route::post('ca-report', ['uses'=>'Api\DocumentsController@ca_report']);
                Route::post('business-doc', ['uses'=>'Api\DocumentsController@business_doc']);
                Route::post('others-doc', ['uses'=>'Api\DocumentsController@others_doc']);
            });

            Route::group(['prefix' => 'application-service'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationServiceController@create']);
                Route::get('list', ['uses'=>'Api\ApplicationServiceController@show']);
                Route::post('list-filter', ['uses'=>'Api\ApplicationServiceController@show_filter']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationServiceController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationServiceController@single']);
            });

            Route::group(['prefix' => 'application'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationController@create']);
                Route::post('list', ['uses'=>'Api\ApplicationController@show']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\ApplicationController@delete']);
                Route::post('notes-create/{id}', ['uses'=>'Api\ApplicationController@notes_create']);
                Route::get('notes-list/{id}', ['uses'=>'Api\ApplicationController@notes_list']);
            });

            Route::group(['prefix' => 'communication', 'as' => 'comm.'], function () {
                Route::post('create', [ 'uses'=>'Api\CommunicationController@create']);
                Route::post('list', ['uses'=>'Api\CommunicationController@show']);
                Route::get('single/{id}', ['uses'=>'Api\CommunicationController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\CommunicationController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\CommunicationController@logCreate']);
                Route::post('logs-list', ['uses'=>'Api\CommunicationController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\CommunicationController@log_status_update']);
            });

            Route::group(['prefix' => 'leads', 'as' => 'leads.'], function () {
                Route::post('create', [ 'uses'=>'Api\LeadsController@create']);
                Route::post('list', ['uses'=>'Api\LeadsController@show']);
                Route::get('single/{id}', ['uses'=>'Api\LeadsController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\LeadsController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\LeadsController@logCreate']);
                Route::get('convert/{id}', ['uses'=>'Api\LeadsController@convert']);
                Route::get('view-profile/{email}', ['uses'=>'Api\LeadsController@viewProfile']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@lead_create']);
                Route::post('logs-list', ['uses'=>'Api\LeadsController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\LeadsController@log_status_update']);
            });
            /*Invoice*/
            /*Settings*/
            Route::group(['prefix' => 'invoice-settings'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\SettingsController@save']);
                Route::get('show', ['uses'=>'Api\Invoice\SettingsController@show']);
            });

            Route::group(['prefix' => 'orders'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\OrdersController@save']);
                Route::post('show', ['uses'=>'Api\Invoice\OrdersController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Invoice\OrdersController@single']);
            });

            Route::group(['prefix' => 'invoice'], function () {
                Route::post('generate', [ 'uses'=>'Api\Invoice\InvoiceController@save']);
                Route::get('show/{orderId}', ['uses'=>'Api\Invoice\InvoiceController@show']);
                Route::get('single/{orderId}/{id}', ['uses'=>'Api\Invoice\InvoiceController@single']);
                Route::post('cancel', ['uses'=>'Api\Invoice\InvoiceController@cancel']);
                Route::post('listall', ['uses'=>'Api\Invoice\InvoiceController@showList']);
            });

            Route::group(['prefix' => 'events'], function () {
                Route::post('add-new', [ 'uses'=>'Api\EventsController@create']);
                Route::post('update/{id}', [ 'uses'=>'Api\EventsController@update']);
                Route::get('show', ['uses'=>'Api\EventsController@show']);
                Route::get('customList', ['uses'=>'Api\EventsController@customList']);
                Route::get('single/{id}', [ 'uses'=>'Api\EventsController@single']);
                Route::get('delete/{id}', ['uses'=>'Api\EventsController@delete']);
            });


        });

        /*Manager*/
        Route::group(['prefix' => 'manager', 'as' => 'manager.','middleware'=>['auth:api','api.manager']], function () {

            Route::post('search', [ 'uses'=>'Api\SearchController@show']);

            Route::group(['prefix' => 'today-task', 'as' => 'today_task.'], function () {
                Route::post('create', [ 'uses'=>'Api\TodaytaskController@create']);
                Route::get('list', ['uses'=>'Api\TodaytaskController@show']);
                Route::post('update/{id}', ['uses'=>'Api\TodaytaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TodaytaskController@single']);
                Route::get('delete/{id}', [ 'uses'=>'Api\TodaytaskController@delete']);
            });
           Route::get('intructions',['uses'=>"Api\HomeController@instruction"]);
            Route::group(['prefix' => 'staff', 'as' => 'staff.'], function () {
                Route::post('create', [ 'uses'=>'Api\Manager\StaffController@create']);
                Route::get('list', ['uses'=>'Api\Manager\StaffController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Manager\StaffController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\Manager\StaffController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Manager\StaffController@delete']);
            });
            Route::group(['prefix' => 'agent', 'as' => 'agent.'], function () {
                Route::post('create', ['as'=>'register_agent', 'uses'=>'Api\Manager\AgentController@create']);
                Route::get('list', ['as'=>'register_agent', 'uses'=>'Api\Manager\AgentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Manager\AgentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Manager\AgentController@edit']);

                Route::get('task/{id}', ['uses'=>'Api\Manager\AgentController@task']);
            });

            Route::group(['prefix' => 'associate', 'as' => 'associate.'], function () {
                Route::post('create', [ 'uses'=>'Api\Manager\AssociateController@create']);
                Route::get('list', ['uses'=>'Api\Manager\AssociateController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Manager\AssociateController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\Manager\AssociateController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Manager\AssociateController@delete']);
                Route::get('task/{id}', ['uses'=>'Api\Manager\AssociateController@task']);
            });

            Route::group(['prefix' => 'student', 'as' => 'student.'], function () {
                Route::post('create', [ 'uses'=>'Api\Manager\StudentController@create']);
                Route::get('list', ['uses'=>'Api\Manager\StudentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Manager\StudentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Manager\StudentController@edit']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@student_create']);
            });



            Route::group(['prefix' => 'set-documents'], function () {
                Route::post('create', [ 'uses'=>'Api\Manager\DocumentsController@create']);
                Route::post('list', ['uses'=>'Api\Manager\DocumentsController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Manager\DocumentsController@delete']);

                Route::post('assign-student', [ 'uses'=>'Api\Manager\DocumentsController@assign']);
                Route::post('assign-student-list', [ 'uses'=>'Api\Manager\DocumentsController@showDocByStudent']);
                Route::delete('assign-delete/{id}', [ 'uses'=>'Api\Manager\DocumentsController@delete_assign']);
            });

            Route::group(['prefix' => 'retrainer-agreement'], function () {
                Route::post('create', ['uses'=>'Api\Manager\RetrainerAgreementController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\Manager\RetrainerAgreementController@show']);

            });

            Route::group(['prefix' => 'calender'], function () {
                Route::post('create', ['uses'=>'Api\CalenderController@create']);
                Route::get('list', ['uses'=>'Api\CalenderController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\CalenderController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\CalenderController@update']);
                Route::get('single/{id}', ['uses'=>'Api\CalenderController@single']);
            });

            Route::group(['prefix' => 'tasks'], function () {
                Route::post('create', ['uses'=>'Api\TaskController@create']);
                Route::get('list', ['uses'=>'Api\TaskController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\TaskController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\TaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TaskController@single']);
            });
            Route::group(['prefix' => 'notes'], function () {
                Route::post('create', ['uses'=>'Api\Manager\NotesController@create']);
                Route::get('list', ['uses'=>'Api\Manager\NotesController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\Manager\NotesController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Manager\NotesController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\Manager\NotesController@update']);
            });

            Route::group(['prefix' => 'notes-system'], function () {
                Route::post('create', ['uses'=>'Api\NotesAdminController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\NotesAdminController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\NotesAdminController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\NotesAdminController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\NotesAdminController@update']);
            });

            Route::group(['prefix' => 'documents'], function () {
                Route::post('identity', ['uses'=>'Api\DocumentsController@identity']);
                Route::post('education', ['uses'=>'Api\DocumentsController@education']);
                Route::post('work-experience', ['uses'=>'Api\DocumentsController@work_experience']);
                Route::post('digital-picture', ['uses'=>'Api\DocumentsController@digital_picture']);
                Route::post('cv-resume', ['uses'=>'Api\DocumentsController@cv_resume']);
                Route::post('funds-proof', ['uses'=>'Api\DocumentsController@funds_proof']);
                Route::post('ca-report', ['uses'=>'Api\DocumentsController@ca_report']);
                Route::post('business-doc', ['uses'=>'Api\DocumentsController@business_doc']);
                Route::post('others-doc', ['uses'=>'Api\DocumentsController@others_doc']);
            });

            Route::group(['prefix' => 'application'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationController@create']);
                Route::post('list', ['uses'=>'Api\ApplicationController@show']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationController@single']);
                Route::post('notes-create/{id}', ['uses'=>'Api\ApplicationController@notes_create']);
                Route::get('notes-list/{id}', ['uses'=>'Api\ApplicationController@notes_list']);
            });

            Route::group(['prefix' => 'communication', 'as' => 'comm.'], function () {
                Route::post('create', [ 'uses'=>'Api\CommunicationController@create']);
                Route::post('list', ['uses'=>'Api\CommunicationController@show']);
                Route::get('single/{id}', ['uses'=>'Api\CommunicationController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\CommunicationController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\CommunicationController@logCreate']);
                Route::post('logs-list', ['uses'=>'Api\CommunicationController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\CommunicationController@log_status_update']);
            });

            Route::group(['prefix' => 'leads', 'as' => 'leads.'], function () {
                Route::post('create', [ 'uses'=>'Api\LeadsController@create']);
                Route::post('list', ['uses'=>'Api\LeadsController@show']);
                Route::get('single/{id}', ['uses'=>'Api\LeadsController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\LeadsController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\LeadsController@logCreate']);
                Route::get('convert/{id}', ['uses'=>'Api\LeadsController@convert']);
                Route::get('view-profile/{email}', ['uses'=>'Api\LeadsController@viewProfile']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@lead_create']);
                Route::post('logs-list', ['uses'=>'Api\LeadsController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\LeadsController@log_status_update']);
            });

            Route::group(['prefix' => 'manager', 'as' => 'manager.'], function () {
                Route::get('list', ['uses'=>'Api\Manager\ManagerController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Manager\ManagerController@single']);
            });
            /*Settings*/
            Route::group(['prefix' => 'invoice-settings'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\SettingsController@save']);
                Route::get('show', ['uses'=>'Api\Invoice\SettingsController@show']);
            });
            Route::group(['prefix' => 'orders'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\OrdersController@save']);
                Route::post('show', ['uses'=>'Api\Invoice\OrdersController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Invoice\OrdersController@single']);
            });

            Route::group(['prefix' => 'invoice'], function () {
                Route::post('generate', [ 'uses'=>'Api\Invoice\InvoiceController@save']);
                Route::get('show/{orderId}', ['uses'=>'Api\Invoice\InvoiceController@show']);
                Route::get('single/{orderId}/{id}', ['uses'=>'Api\Invoice\InvoiceController@single']);
                Route::post('cancel', ['uses'=>'Api\Invoice\InvoiceController@cancel']);
                Route::post('listall', ['uses'=>'Api\Invoice\InvoiceController@showList']);
            });
            Route::group(['prefix' => 'events'], function () {
                Route::post('add-new', [ 'uses'=>'Api\EventsController@create']);
                Route::post('update/{id}', [ 'uses'=>'Api\EventsController@update']);
                Route::get('show', ['uses'=>'Api\EventsController@show']);
                Route::get('customList', ['uses'=>'Api\EventsController@customList']);
                Route::get('single/{id}', [ 'uses'=>'Api\EventsController@single']);
                Route::get('delete/{id}', ['uses'=>'Api\EventsController@delete']);
            });

            Route::group(['prefix' => 'application-service'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationServiceController@create']);
                Route::get('list', ['uses'=>'Api\ApplicationServiceController@show']);
                Route::post('list-filter', ['uses'=>'Api\ApplicationServiceController@show_filter']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationServiceController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationServiceController@single']);
            });

        });

        /*Staff*/
        Route::group(['prefix' => 'staff', 'as' => 'staff.','middleware'=>['auth:api','api.staff']], function () {
            Route::get('intructions',['uses'=>"Api\HomeController@instruction"]);

            Route::post('search', [ 'uses'=>'Api\SearchController@show']);

            Route::group(['prefix' => 'today-task', 'as' => 'today_task.'], function () {
                Route::post('create', [ 'uses'=>'Api\TodaytaskController@create']);
                Route::get('list', ['uses'=>'Api\TodaytaskController@show']);
                Route::post('update/{id}', ['uses'=>'Api\TodaytaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TodaytaskController@single']);
                Route::get('delete/{id}', [ 'uses'=>'Api\TodaytaskController@delete']);
            });

            Route::group(['prefix' => 'staff', 'as' => 'staff.'], function () {
                Route::get('list', ['uses'=>'Api\Staff\StaffController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Staff\StaffController@single']);
            });


            Route::group(['prefix' => 'student', 'as' => 'student.'], function () {
                Route::post('create', [ 'uses'=>'Api\Staff\StudentController@create']);
                Route::get('list', ['uses'=>'Api\Staff\StudentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Staff\StudentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Staff\StudentController@edit']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@student_create']);
            });


            Route::group(['prefix' => 'agent', 'as' => 'agent.'], function () {

                Route::get('list', ['as'=>'register_agent', 'uses'=>'Api\Staff\AgentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Staff\AgentController@single']);
            });

            Route::group(['prefix' => 'associate', 'as' => 'associate.'], function () {
                Route::get('list', ['uses'=>'Api\Staff\AssociateController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Staff\AssociateController@single']);
            });
            Route::group(['prefix' => 'manager', 'as' => 'manager.'], function () {

                Route::get('list', ['as'=>'register_agent', 'uses'=>'Api\Staff\ManagerController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Staff\ManagerController@single']);
            });

            Route::group(['prefix' => 'application'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationController@create']);
                Route::post('list', ['uses'=>'Api\ApplicationController@show']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationController@single']);
                Route::post('notes-create/{id}', ['uses'=>'Api\ApplicationController@notes_create']);
                Route::get('notes-list/{id}', ['uses'=>'Api\ApplicationController@notes_list']);
            });

            Route::group(['prefix' => 'documents'], function () {
                Route::post('identity', ['uses'=>'Api\DocumentsController@identity']);
                Route::post('education', ['uses'=>'Api\DocumentsController@education']);
                Route::post('work-experience', ['uses'=>'Api\DocumentsController@work_experience']);
                Route::post('digital-picture', ['uses'=>'Api\DocumentsController@digital_picture']);
                Route::post('cv-resume', ['uses'=>'Api\DocumentsController@cv_resume']);
                Route::post('funds-proof', ['uses'=>'Api\DocumentsController@funds_proof']);
                Route::post('ca-report', ['uses'=>'Api\DocumentsController@ca_report']);
                Route::post('business-doc', ['uses'=>'Api\DocumentsController@business_doc']);
                Route::post('others-doc', ['uses'=>'Api\DocumentsController@others_doc']);
            });

            Route::group(['prefix' => 'calender'], function () {
                Route::post('create', ['uses'=>'Api\CalenderController@create']);
                Route::get('list', ['uses'=>'Api\CalenderController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\CalenderController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\CalenderController@update']);
                Route::get('single/{id}', ['uses'=>'Api\CalenderController@single']);
            });


            Route::group(['prefix' => 'communication', 'as' => 'comm.'], function () {
                Route::post('create', [ 'uses'=>'Api\CommunicationController@create']);
                Route::post('list', ['uses'=>'Api\CommunicationController@show']);
                Route::post('update/{id}', [ 'uses'=>'Api\CommunicationController@update']);
                Route::get('single/{id}', ['uses'=>'Api\CommunicationController@single']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\CommunicationController@logCreate']);
                Route::post('logs-list', ['uses'=>'Api\CommunicationController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\CommunicationController@log_status_update']);
            });

            Route::group(['prefix' => 'leads', 'as' => 'leads.'], function () {
                Route::post('create', [ 'uses'=>'Api\LeadsController@create']);
                Route::post('list', ['uses'=>'Api\LeadsController@show']);
                Route::get('single/{id}', ['uses'=>'Api\LeadsController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\LeadsController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\LeadsController@logCreate']);
                Route::get('convert/{id}', ['uses'=>'Api\LeadsController@convert']);
                Route::get('view-profile/{email}', ['uses'=>'Api\LeadsController@viewProfile']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@lead_create']);
                Route::post('logs-list', ['uses'=>'Api\LeadsController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\LeadsController@log_status_update']);
            });
            /*Settings*/
            Route::group(['prefix' => 'invoice-settings'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\SettingsController@save']);
                Route::get('show', ['uses'=>'Api\Invoice\SettingsController@show']);
            });
            Route::group(['prefix' => 'orders'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\OrdersController@save']);
                Route::post('show', ['uses'=>'Api\Invoice\OrdersController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Invoice\OrdersController@single']);
            });
            Route::group(['prefix' => 'invoice'], function () {
                Route::post('generate', [ 'uses'=>'Api\Invoice\InvoiceController@save']);
                Route::get('show/{orderId}', ['uses'=>'Api\Invoice\InvoiceController@show']);
                Route::get('single/{orderId}/{id}', ['uses'=>'Api\Invoice\InvoiceController@single']);
                Route::post('cancel', ['uses'=>'Api\Invoice\InvoiceController@cancel']);
                Route::post('listall', ['uses'=>'Api\Invoice\InvoiceController@showList']);
            });
            Route::group(['prefix' => 'events'], function () {
                Route::post('add-new', [ 'uses'=>'Api\EventsController@create']);
                Route::post('update/{id}', [ 'uses'=>'Api\EventsController@update']);
                Route::get('show', ['uses'=>'Api\EventsController@show']);
                Route::get('customList', ['uses'=>'Api\EventsController@customList']);
                Route::get('single/{id}', [ 'uses'=>'Api\EventsController@single']);
                Route::get('delete/{id}', ['uses'=>'Api\EventsController@delete']);
            });

            Route::group(['prefix' => 'application-service'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationServiceController@create']);
                Route::get('list', ['uses'=>'Api\ApplicationServiceController@show']);
                Route::post('list-filter', ['uses'=>'Api\ApplicationServiceController@show_filter']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationServiceController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationServiceController@single']);
            });

        });

        /*Agent*/
        Route::group(['prefix' => 'agent', 'as' => 'agent.','middleware'=>['auth:api','api.agent']], function () {
            Route::get('user',function(Request $request){
                return $request->user();
            });

            Route::group(['prefix' => 'agent', 'as' => 'agent.'], function () {
                Route::get('list', ['uses'=>'Api\Agent\AgentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Agent\AgentController@single']);
            });

            Route::group(['prefix' => 'associate'], function () {
                Route::get('list', ['uses'=>'Api\Agent\AssociateController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Agent\AssociateController@single']);
            });

            Route::post('search', [ 'uses'=>'Api\SearchController@show']);

            Route::group(['prefix' => 'today-task', 'as' => 'today_task.'], function () {
                Route::post('create', [ 'uses'=>'Api\TodaytaskController@create']);
                Route::get('list', ['uses'=>'Api\TodaytaskController@show']);
                Route::post('update/{id}', ['uses'=>'Api\TodaytaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TodaytaskController@single']);
                Route::get('delete/{id}', [ 'uses'=>'Api\TodaytaskController@delete']);
            });

            Route::get('intructions',['uses'=>"Api\HomeController@instruction"]);
            Route::group(['prefix' => 'student', 'as' => 'student.'], function () {
                Route::post('create', [ 'uses'=>'Api\Agent\StudentController@create']);
                Route::get('list', ['uses'=>'Api\Agent\StudentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Agent\StudentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Agent\StudentController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Agent\StudentController@delete']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@student_create']);
            });

            Route::group(['prefix' => 'set-documents'], function () {
                Route::post('list', ['uses'=>'Api\Agent\DocumentsController@show']);
                Route::post('assign-student', [ 'uses'=>'Api\Agent\DocumentsController@assign']);
                Route::post('assign-student-list', [ 'uses'=>'Api\Agent\DocumentsController@showDocByStudent']);
                Route::delete('assign-delete/{id}', [ 'uses'=>'Api\Agent\DocumentsController@delete_assign']);
            });

            Route::group(['prefix' => 'calender'], function () {
                Route::post('create', ['uses'=>'Api\CalenderController@create']);
                Route::get('list', ['uses'=>'Api\CalenderController@show']);
                Route::get('single/{id}', ['uses'=>'Api\CalenderController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\CalenderController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\CalenderController@update']);
            });


            Route::group(['prefix' => 'tasks'], function () {
                Route::post('status-update/{id}', ['uses'=>'Api\TaskController@status']);
                Route::get('list', ['uses'=>'Api\TaskController@showAgent']);
                Route::get('single/{id}', ['uses'=>'Api\TaskController@showAgentSingle']);
            });
            Route::group(['prefix' => 'notes'], function () {

                Route::post('create', ['uses'=>'Api\Agent\NotesController@create']);
                Route::get('list', ['uses'=>'Api\Agent\NotesController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\Admin\NotesController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Agent\NotesController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\Agent\NotesController@update']);
            });

            Route::group(['prefix' => 'notes-system'], function () {
                Route::post('create', ['uses'=>'Api\NotesAdminController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\NotesAdminController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\NotesAdminController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\NotesAdminController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\NotesAdminController@update']);
            });

            Route::group(['prefix' => 'retrainer-agreement'], function () {
                Route::post('create', ['uses'=>'Api\Agent\RetrainerAgreementController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\Agent\RetrainerAgreementController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Agent\RetrainerAgreementController@delete']);
            });

            Route::group(['prefix' => 'documents'], function () {
                Route::post('identity', ['uses'=>'Api\DocumentsController@identity']);
                Route::post('education', ['uses'=>'Api\DocumentsController@education']);
                Route::post('work-experience', ['uses'=>'Api\DocumentsController@work_experience']);
                Route::post('digital-picture', ['uses'=>'Api\DocumentsController@digital_picture']);
                Route::post('cv-resume', ['uses'=>'Api\DocumentsController@cv_resume']);
                Route::post('funds-proof', ['uses'=>'Api\DocumentsController@funds_proof']);
                Route::post('ca-report', ['uses'=>'Api\DocumentsController@ca_report']);
                Route::post('business-doc', ['uses'=>'Api\DocumentsController@business_doc']);
                Route::post('others-doc', ['uses'=>'Api\DocumentsController@others_doc']);
            });
            Route::group(['prefix' => 'application'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationController@create']);
                Route::post('list', ['uses'=>'Api\ApplicationController@show']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\ApplicationController@delete']);
                Route::post('notes-create/{id}', ['uses'=>'Api\ApplicationController@notes_create']);
                Route::get('notes-list/{id}', ['uses'=>'Api\ApplicationController@notes_list']);
            });

            Route::group(['prefix' => 'communication', 'as' => 'comm.'], function () {
                Route::post('create', [ 'uses'=>'Api\CommunicationController@create']);
                Route::post('list', ['uses'=>'Api\CommunicationController@show']);
                Route::get('single/{id}', ['uses'=>'Api\CommunicationController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\CommunicationController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\CommunicationController@logCreate']);
                Route::post('logs-list', ['uses'=>'Api\CommunicationController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\CommunicationController@log_status_update']);
            });

            Route::group(['prefix' => 'staff', 'as' => 'staff.'], function () {
                Route::get('list', ['as'=>'staff_list', 'uses'=>'Api\Agent\StaffController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Agent\StaffController@single']);
            });

            Route::group(['prefix' => 'manager', 'as' => 'manager.'], function () {

                Route::get('list', ['as'=>'register_agent', 'uses'=>'Api\Agent\ManagerController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Agent\ManagerController@single']);
            });

            Route::group(['prefix' => 'leads', 'as' => 'leads.'], function () {
                Route::post('create', [ 'uses'=>'Api\LeadsController@create']);
                Route::post('list', ['uses'=>'Api\LeadsController@show']);
                Route::get('single/{id}', ['uses'=>'Api\LeadsController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\LeadsController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\LeadsController@logCreate']);
                Route::get('convert/{id}', ['uses'=>'Api\LeadsController@convert']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@lead_create']);
                Route::post('logs-list', ['uses'=>'Api\LeadsController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\LeadsController@log_status_update']);
            });
            /*Settings*/
            Route::group(['prefix' => 'invoice-settings'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\SettingsController@save']);
                Route::get('show', ['uses'=>'Api\Invoice\SettingsController@show']);
            });
            Route::group(['prefix' => 'orders'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\OrdersController@save']);
                Route::post('show', ['uses'=>'Api\Invoice\OrdersController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Invoice\OrdersController@single']);
            });

            Route::group(['prefix' => 'invoice'], function () {
                Route::post('generate', [ 'uses'=>'Api\Invoice\InvoiceController@save']);
                Route::get('show/{orderId}', ['uses'=>'Api\Invoice\InvoiceController@show']);
                Route::get('single/{orderId}/{id}', ['uses'=>'Api\Invoice\InvoiceController@single']);
                Route::post('cancel', ['uses'=>'Api\Invoice\InvoiceController@cancel']);
                Route::post('listall', ['uses'=>'Api\Invoice\InvoiceController@showList']);
            });
            Route::group(['prefix' => 'events'], function () {
                Route::post('add-new', [ 'uses'=>'Api\EventsController@create']);
                Route::post('update/{id}', [ 'uses'=>'Api\EventsController@update']);
                Route::get('show', ['uses'=>'Api\EventsController@show']);
                Route::get('customList', ['uses'=>'Api\EventsController@customList']);
                Route::get('single/{id}', [ 'uses'=>'Api\EventsController@single']);
                Route::get('delete/{id}', ['uses'=>'Api\EventsController@delete']);
            });

            Route::group(['prefix' => 'application-service'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationServiceController@create']);
                Route::get('list', ['uses'=>'Api\ApplicationServiceController@show']);
                Route::post('list-filter', ['uses'=>'Api\ApplicationServiceController@show_filter']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationServiceController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationServiceController@single']);
            });

        });


        /*Associate*/
        Route::group(['prefix' => 'associate', 'as' => 'associate.','middleware'=>['auth:api','api.associate']], function () {
            Route::get('user',function(Request $request){
                return $request->user();
            });

            Route::group(['prefix' => 'associate'], function () {
                Route::get('list', ['uses'=>'Api\Associate\AssociateController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Associate\AssociateController@single']);
            });

            Route::group(['prefix' => 'agent', 'as' => 'agent.'], function () {
                Route::get('list', ['uses'=>'Api\Associate\AgentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Associate\AgentController@single']);
            });

            Route::post('search', [ 'uses'=>'Api\SearchController@show']);

            Route::group(['prefix' => 'today-task', 'as' => 'today_task.'], function () {
                Route::post('create', [ 'uses'=>'Api\TodaytaskController@create']);
                Route::get('list', ['uses'=>'Api\TodaytaskController@show']);
                Route::post('update/{id}', ['uses'=>'Api\TodaytaskController@update']);
                Route::get('single/{id}', ['uses'=>'Api\TodaytaskController@single']);
                Route::get('delete/{id}', [ 'uses'=>'Api\TodaytaskController@delete']);
            });

            Route::get('intructions',['uses'=>"Api\HomeController@instruction"]);
            Route::group(['prefix' => 'student', 'as' => 'student.'], function () {
                Route::post('create', [ 'uses'=>'Api\Associate\StudentController@create']);
                Route::get('list', ['uses'=>'Api\Associate\StudentController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Associate\StudentController@single']);
                Route::put('update/{id}', [ 'uses'=>'Api\Associate\StudentController@edit']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Associate\StudentController@delete']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@student_create']);
            });

            Route::group(['prefix' => 'set-documents'], function () {
                Route::post('list', ['uses'=>'Api\Associate\DocumentsController@show']);
                Route::post('assign-student', [ 'uses'=>'Api\Associate\DocumentsController@assign']);
                Route::post('assign-student-list', [ 'uses'=>'Api\Associate\DocumentsController@showDocByStudent']);
                Route::delete('assign-delete/{id}', [ 'uses'=>'Api\Associate\DocumentsController@delete_assign']);
            });

            Route::group(['prefix' => 'calender'], function () {
                Route::post('create', ['uses'=>'Api\CalenderController@create']);
                Route::get('list', ['uses'=>'Api\CalenderController@show']);
                Route::get('single/{id}', ['uses'=>'Api\CalenderController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\CalenderController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\CalenderController@update']);
            });


            Route::group(['prefix' => 'tasks'], function () {
                Route::post('status-update/{id}', ['uses'=>'Api\TaskController@status']);
                Route::get('list', ['uses'=>'Api\TaskController@showAgent']);
                Route::get('single/{id}', ['uses'=>'Api\TaskController@showAgentSingle']);
            });
            Route::group(['prefix' => 'notes'], function () {

                Route::post('create', ['uses'=>'Api\Associate\NotesController@create']);
                Route::get('list', ['uses'=>'Api\Associate\NotesController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\Associate\NotesController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Associate\NotesController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\Associate\NotesController@update']);
            });

            Route::group(['prefix' => 'notes-system'], function () {
                Route::post('create', ['uses'=>'Api\NotesAdminController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\NotesAdminController@show']);
                Route::get('single/{id}', [ 'uses'=>'Api\NotesAdminController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\NotesAdminController@delete']);
                Route::post('update/{id}', ['uses'=>'Api\NotesAdminController@update']);
            });

            Route::group(['prefix' => 'retrainer-agreement'], function () {
                Route::post('create', ['uses'=>'Api\Associate\RetrainerAgreementController@create']);
                Route::get('list/{studentid}', ['uses'=>'Api\Associate\RetrainerAgreementController@show']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\Associate\RetrainerAgreementController@delete']);
            });
/*** */
            Route::group(['prefix' => 'documents'], function () {
                Route::post('identity', ['uses'=>'Api\DocumentsController@identity']);
                Route::post('education', ['uses'=>'Api\DocumentsController@education']);
                Route::post('work-experience', ['uses'=>'Api\DocumentsController@work_experience']);
                Route::post('digital-picture', ['uses'=>'Api\DocumentsController@digital_picture']);
                Route::post('cv-resume', ['uses'=>'Api\DocumentsController@cv_resume']);
                Route::post('funds-proof', ['uses'=>'Api\DocumentsController@funds_proof']);
                Route::post('ca-report', ['uses'=>'Api\DocumentsController@ca_report']);
                Route::post('business-doc', ['uses'=>'Api\DocumentsController@business_doc']);
                Route::post('others-doc', ['uses'=>'Api\DocumentsController@others_doc']);
            });
            /**** */
            Route::group(['prefix' => 'application'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationController@create']);
                Route::post('list', ['uses'=>'Api\ApplicationController@show']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationController@single']);
                Route::delete('delete/{id}', [ 'uses'=>'Api\ApplicationController@delete']);
                Route::post('notes-create/{id}', ['uses'=>'Api\ApplicationController@notes_create']);
                Route::get('notes-list/{id}', ['uses'=>'Api\ApplicationController@notes_list']);
            });
/**** */
            Route::group(['prefix' => 'communication', 'as' => 'comm.'], function () {
                Route::post('create', [ 'uses'=>'Api\CommunicationController@create']);
                Route::post('list', ['uses'=>'Api\CommunicationController@show']);
                Route::get('single/{id}', ['uses'=>'Api\CommunicationController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\CommunicationController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\CommunicationController@logCreate']);
                Route::post('logs-list', ['uses'=>'Api\CommunicationController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\CommunicationController@log_status_update']);
            });

            Route::group(['prefix' => 'staff', 'as' => 'staff.'], function () {
                Route::get('list', ['as'=>'staff_list', 'uses'=>'Api\Associate\StaffController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Associate\StaffController@single']);
            });

            Route::group(['prefix' => 'manager', 'as' => 'manager.'], function () {

                Route::get('list', ['as'=>'register_agent', 'uses'=>'Api\Associate\ManagerController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Associate\ManagerController@single']);
            });

            Route::group(['prefix' => 'leads', 'as' => 'leads.'], function () {
                Route::post('create', [ 'uses'=>'Api\LeadsController@create']);
                Route::post('list', ['uses'=>'Api\LeadsController@show']);
                Route::get('single/{id}', ['uses'=>'Api\LeadsController@single']);
                Route::post('update/{id}', [ 'uses'=>'Api\LeadsController@update']);
                Route::post('log-create/{id}', [ 'uses'=>'Api\LeadsController@logCreate']);
                Route::get('convert/{id}', ['uses'=>'Api\LeadsController@convert']);
                Route::post('create-bulk', [ 'uses'=>'Api\BulkDataSaveController@lead_create']);
                Route::post('logs-list', ['uses'=>'Api\LeadsController@show_logs']);
                Route::post('logs-status-update/{id}', [ 'uses'=>'Api\LeadsController@log_status_update']);
            });

            /*Settings*/
            Route::group(['prefix' => 'invoice-settings'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\SettingsController@save']);
                Route::get('show', ['uses'=>'Api\Invoice\SettingsController@show']);
            });
            Route::group(['prefix' => 'orders'], function () {
                Route::post('save', [ 'uses'=>'Api\Invoice\OrdersController@save']);
                Route::post('show', ['uses'=>'Api\Invoice\OrdersController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Invoice\OrdersController@single']);
            });

            Route::group(['prefix' => 'invoice'], function () {
                Route::post('generate', [ 'uses'=>'Api\Invoice\InvoiceController@save']);
                Route::get('show/{orderId}', ['uses'=>'Api\Invoice\InvoiceController@show']);
                Route::get('single/{orderId}/{id}', ['uses'=>'Api\Invoice\InvoiceController@single']);
                Route::post('cancel', ['uses'=>'Api\Invoice\InvoiceController@cancel']);
                Route::post('listall', ['uses'=>'Api\Invoice\InvoiceController@showList']);
            });
            Route::group(['prefix' => 'events'], function () {
                Route::post('add-new', [ 'uses'=>'Api\EventsController@create']);
                Route::post('update/{id}', [ 'uses'=>'Api\EventsController@update']);
                Route::get('show', ['uses'=>'Api\EventsController@show']);
                Route::get('customList', ['uses'=>'Api\EventsController@customList']);
                Route::get('single/{id}', [ 'uses'=>'Api\EventsController@single']);
                Route::get('delete/{id}', ['uses'=>'Api\EventsController@delete']);
            });

            Route::group(['prefix' => 'application-service'], function () {
                Route::post('create', ['uses'=>'Api\ApplicationServiceController@create']);
                Route::get('list', ['uses'=>'Api\ApplicationServiceController@show']);
                Route::post('list-filter', ['uses'=>'Api\ApplicationServiceController@show_filter']);
                Route::post('update/{id}', ['uses'=>'Api\ApplicationServiceController@update']);
                Route::get('single/{id}', ['uses'=>'Api\ApplicationServiceController@single']);
            });

        });

        /*Student*/
        Route::group(['prefix' => 'student', 'as' => 'student.','middleware'=>['auth:api','api.client']], function () {
            Route::get('user',function(Request $request){
                return $request->user();
            });
            Route::post('myprofile-update', ['uses'=>'Api\Student\HomeController@myprofile_update']);

            Route::group(['prefix' => 'notes'], function () {
                Route::get('list', ['uses'=>'Api\Student\HomeController@notes_show']);
            });

            Route::get('intructions',['uses'=>"Api\Student\HomeController@instruction"]);
            Route::get('retrainer-agreement',['uses'=>"Api\Student\HomeController@retrainer_agreement"]);
            Route::get('set-document-list',['uses'=>"Api\Student\HomeController@set_document_list"]);
            Route::post('set-document-upload/{id}',['uses'=>"Api\Student\HomeController@set_document_upload"]);

            Route::group(['prefix' => 'documents'], function () {
                Route::post('identity', ['uses'=>'Api\Student\DocumentsController@identity']);
                Route::post('education', ['uses'=>'Api\Student\DocumentsController@education']);
                Route::post('work-experience', ['uses'=>'Api\Student\DocumentsController@work_experience']);
                Route::post('digital-picture', ['uses'=>'Api\Student\DocumentsController@digital_picture']);
                Route::post('cv-resume', ['uses'=>'Api\Student\DocumentsController@cv_resume']);
                Route::post('funds-proof', ['uses'=>'Api\Student\DocumentsController@funds_proof']);
                Route::post('ca-report', ['uses'=>'Api\Student\DocumentsController@ca_report']);
                Route::post('business-doc', ['uses'=>'Api\Student\DocumentsController@business_doc']);
                Route::post('others-doc', ['uses'=>'Api\Student\DocumentsController@others_doc']);

                Route::group(['prefix' => 'view'], function () {
                    Route::get('identity/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@identity']);
                    Route::get('education/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@education']);
                    Route::get('work-experience/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@work_experience']);
                    Route::get('digital-picture/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@digital_picture']);
                    Route::get('cv-resume/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@cv_resume']);
                    Route::get('funds-proof/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@funds_proof']);
                    Route::get('ca-report/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@ca_report']);
                    Route::get('business-doc/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@business_doc']);
                    Route::get('others-doc/{applicationid}', ['uses'=>'Api\Student\DocumentsViewController@others_doc']);
                });

                Route::group(['prefix' => 'delete'], function () {

                    Route::get('identity/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@identity_delete']);
                    Route::get('education/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@education_delete']);
                    Route::get('work-experience/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@work_experience_delete']);
                    Route::get('digital-picture/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@digital_picture_delete']);
                    Route::get('cv-resume/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@cv_resume_delete']);
                    Route::get('funds-proof/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@funds_proof_delete']);
                    Route::get('ca-report/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@ca_report_delete']);
                    Route::get('business-doc/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@business_doc_delete']);
                    Route::get('others-doc/{id}/{applicationid}/{field}', ['uses'=>'Api\Student\DocumentsViewController@others_doc_delete']);
                });


            });


            Route::group(['prefix' => 'application'], function () {
                Route::get('list', ['uses'=>'Api\Student\ApplicationController@show']);
                Route::get('single/{id}', ['uses'=>'Api\Student\ApplicationController@single']);
            });


        });

});
