<?php $__env->startSection('title','Order - View'); ?>
<?php $__env->startSection('header_extra'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <div class="col-lg-12">
               <h3>Order #<?php echo e($r->id); ?> <?php echo order_status($r->status); ?></h3> 
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-6">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Order Information</h4>
            <table class="table table-bordered">
                <tr>
                    <th>Customer</th>
                    <td><a target='_blank' href="<?php echo e(route('admin.user.editForm',$r->user->id)); ?>"><?php echo e($r->user->name .' '.$r->user->last_name); ?></a></td>
                </tr>
                <tr>
                    <th>Payment</th>
                    <td><?php echo e($r->payment); ?></td>
                </tr>
                <tr>
                    <th>Payment Status</th>
                    <td>
                        <?php if($r->payment_status == "Paid"): ?>
                        <span class='label label-success'>Paid</span>
                        <?php else: ?>
                        <span class='label label-danger'><?php echo e($r->payment_status); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th>Transaction ID</th>
                    <td><?php echo e($r->transaction_id); ?></td>
                </tr>
                <tr>
                    <th>Transaction Date</th>
                    <td><?php echo e(date('m-d-Y h:i A',  strtotime($r->created_at))); ?></td>
                </tr>
                <tr>
                    <th>Order Status</th>
                    <td><?php echo order_status($r->status); ?></td>
                </tr>
                
                <?php if(!empty($invoice)): ?>
                <tr>
                    <th>View/Print Invoice</th>
                    <td><a href="<?php echo e(route('invoice_view',$r->id)); ?>" style="color: red;"><i class="fa fa-file-pdf-o"></i></a></td>
                </tr>
                <?php endif; ?>
            </table>
               
        </div>
    </div>
    
    <div class="col-6">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Order Action</h4>
               <form class="form-horizontal validate" action="<?php echo e(route('admin.order.edit_update',$r->id)); ?>" method="post" role="form" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-group row">
                        <label class="col-2 col-form-label">Status <span class="text-danger">*</span></label>
                        <div class="col-8">
                            <select class="form-control" name="status">
                                <option value="0" <?php echo e(($r->status == "0" ? "selected":"")); ?>>Completed</option>
                                <option value="2" <?php echo e(($r->status == "2" ? "selected":"")); ?>>Refund</option>
                                <option value="3" <?php echo e(($r->status == "3" ? "selected":"")); ?>>Cancelled</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-8 offset-4">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Update
                            </button>

                        </div>
                    </div>
               </form>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 m-b-30 header-title">Package Purchase</h4>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Days</th>
                        <th>Price</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $data= json_decode($r->package_detail);?>
                    <?php if(!empty($data)): ?>
                    <tr>
                        <td><?php echo e($data->id); ?></td>
                        <td><?php echo e($data->name); ?></td>
                        <td><?php echo e($data->days); ?></td>
                        <td><?php echo e($data->price); ?></td>
                        
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>

<script type="text/javascript">
    
    $(function(){
        $(this).active_menu("orders");
    });
    
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aerocodex/public_html/portal/project/resources/views/admin/orders/view.blade.php ENDPATH**/ ?>