<?php $__env->startSection('title','My Profile'); ?>
<?php $__env->startSection('header_extra'); ?>
<link href="<?php echo e(asset('assets/plugins/datatables/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(asset('assets/plugins/datatables/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<!-- Responsive datatable examples -->
<link href="<?php echo e(asset('assets/plugins/datatables/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    
    
    <div class="col-sm-12">
        <div class="profile-bg-picture">
            <span class="picture-bg-overlay"></span><!-- overlay -->
        </div>
        <!-- meta -->
        <div class="profile-user-box">
            <div class="row">
                <div class="col-sm-4">
                    <span class="pull-left m-r-15">
                        <?php if($r->picture!=""): ?>
                        <img src="<?php echo e(asset('uploads/profile/'.$r->picture)); ?>" alt="" class="thumb-lg rounded-circle">
                        <?php endif; ?>
                    </span>
                    <div class="media-body">
                        <h4 class="m-t-5 m-b-5 font-18 ellipsis"><?php echo e($r->name.' '.$r->last_name); ?></h4>
                        <p class="font-13"> Admin</p>
                        <p class="text-muted m-b-0"><small><?php echo e($r->state. ' '.$r->country); ?></small></p>
                    </div>
                </div>
                <div class="col-sm-4">
                    <?php $active_subscription =  get_active_subscription($r->id); ?>
                    <?php if(!empty($active_subscription)): ?>
                    <div class="text-center">
                        <h2>Subscribed</h2>
                        <h4>  
                            <span class="label label-success"><?php echo e($active_subscription->name); ?> - <?php echo e(package_information($active_subscription->stripe_plan,'duration')); ?></span>
                        </h4>
                    </div>
                    <?php else: ?>
                    <div class="text-center"><h4> <span class="label label-danger">Still not purchase subscription</span></h4></div>
                    <?php endif; ?>
                </div>
                <div class="col-sm-4">
                    <div class="text-right">
                        <?php if($r->secret_key==""): ?>
                        <a href="<?php echo e(route('admin.user.key_generate',$r->id)); ?>" class="btn btn-success waves-effect waves-light">
                            <i class="fa fa-key m-r-5"></i> 
                            Generate Keys
                        </a>
                        <?php else: ?>
                        <a href="<?php echo e(route('admin.user.key_generate',$r->id)); ?>" class="btn btn-success waves-effect waves-light">
                            <i class="fa fa-key m-r-5"></i> 
                            Re-Generate Keys
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="m-t-15 col-12">
                    <?php echo $__env->make('widget/notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                
            </div>
        </div>
        <!--/ meta -->
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <!-- Personal-Information -->
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Personal Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Full Name :</strong> <span class="m-l-15"><?php echo e($r->name.' '.$r->last_name); ?></span></p>

                    <p class="text-muted font-13"><strong>Mobile :</strong><span class="m-l-15"><?php echo e($r->phone); ?></span></p>

                    <p class="text-muted font-13"><strong>Email :</strong> <span class="m-l-15"><?php echo e($r->email); ?></span></p>

                    <p class="text-muted font-13"><strong>Address :</strong> <span class="m-l-15"><?php echo e($r->address); ?></span></p>
                    
                    
                    <p class="text-muted font-13"><strong>Company Name :</strong> <span class="m-l-15"><?php echo e($r->company_name); ?></span></p>
                    <p class="text-muted font-13"><strong>Web Site :</strong> <span class="m-l-15"><?php echo e($r->website); ?></span></p>
                    <p class="text-muted font-13"><strong>Company Name :</strong> <span class="m-l-15"><?php echo e($r->company_name); ?></span></p>
                    <p class="text-muted font-13"><strong>Company Email :</strong> <span class="m-l-15"><?php echo e($r->company_email); ?></span></p>
                    <p class="text-muted font-13"><strong>Company Phone Number :</strong> <span class="m-l-15"><?php echo e($r->company_phone); ?></span></p>
                    <p class="text-muted font-13"><strong>Number of employee :</strong> <span class="m-l-15"><?php echo e($r->number_employee); ?></span></p>
                    <p class="text-muted font-13"><strong>Privacy Policy Link :</strong> <span class="m-l-15"> <a href="<?php echo e($r->privacy_policy_link); ?>"><?php echo e($r->privacy_policy_link); ?></a> </span></p>
                    
                    
                    <p class="text-muted font-13"><strong>City :</strong> <span class="m-l-15"><?php echo e($r->city); ?></span></p>
                    <p class="text-muted font-13"><strong>Province :</strong> <span class="m-l-15"><?php echo e($r->state); ?></span></p>
                    <p class="text-muted font-13"><strong>Country :</strong> <span class="m-l-15"><?php echo e($r->country); ?></span></p>
                    <p class="text-muted font-13"><strong>Postal :</strong> <span class="m-l-15"><?php echo e($r->zipcode); ?></span></p>
                    <p class="text-muted font-13"><strong>Status :</strong> 
                        <span class="m-l-15">
                            <?php if($r->status == "1"): ?>
                            <span class="label label-success">Active</span>
                            <?php elseif($r->status == "0"): ?>
                            <span class="label label-danger">Disable</span>
                            <?php endif; ?>
                            
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <!-- Personal-Information -->

        

    </div>

    <div class="col-md-6">
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Account Update</h4>
            <div class="panel-body">
                
                
                
                <form class="form-horizontal validate" action="<?php echo e(route('admin.user.edit_update',$r->id)); ?>" method="post" role="form" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="form-group row">
                        <label class="col-2 col-form-label">Account Status</label>
                        <div class="col-8">
                            <select class="form-control" name="status">
                                <option value="1" <?php echo e(($r->status == "1" ? "selected":"")); ?>>Active</option>
                                <option value="0" <?php echo e(($r->status == "0" ? "selected":"")); ?>>De-Active</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <label class="col-2 col-form-label">New Note</label>
                        <div class="col-8">
                            <textarea class="form-control" name="note"></textarea>
                        </div>
                    </div>
                    
                    
                    <div class="form-group row">
                        <div class="col-8 offset-4">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Submit
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">API Account</h4>
            <div class="panel-body">
                
                
                
                <form class="form-horizontal validate" action="<?php echo e(route('admin.user.edit_update',$r->id)); ?>" method="post" role="form" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    
                    
                    <div class="form-group row">
                        <label class="col-2 col-form-label">API Service Status</label>
                        <div class="col-8">
                            <select class="form-control" name="api_status">
                                <option value="1" <?php echo e(($r->api_status == "1" ? "selected":"")); ?>>Active</option>
                                <option value="0" <?php echo e(($r->api_status == "0" ? "selected":"")); ?>>Stop</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="form-group row">
                        <div class="col-8 offset-4">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Submit
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- end col -->

</div>
<?php if(!empty($active_subscription)): ?>
<div class="row">
    <div class="col-md-6">
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Subscription Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <?php $pack =  package_information($active_subscription->stripe_plan,''); ?>
                    <p class="text-muted font-13"><strong>Active Date :</strong> <span class="m-l-15"><?php echo e(date('M-d Y h:i a',strtotime($active_subscription->created_at))); ?></span></p>
                    <p class="text-muted font-13"><strong>Package Name :</strong> <span class="m-l-15"><?php echo e($pack->name); ?></span></p>
                    <p class="text-muted font-13"><strong>Duration :</strong> <span class="m-l-15"><?php echo e($pack->duration); ?></span></p>
                    <p class="text-muted font-13"><strong>Price :</strong> <span class="m-l-15"><?php echo e($pack->price); ?></span></p>
                    <?php if($active_subscription->ends_at!=""): ?>
                    <p class="text-muted font-13">
                        <button type="button" class="btn btn-danger" > Subscription will cancel at <?php echo e(date('M-d Y h:i a',strtotime($active_subscription->ends_at))); ?></button>
                 
                    </p>
                    <?php endif; ?>
                    <div class="row">
                        <div class="col-md-12 mx-auto">
                            <div class="row">
                                <?php if($active_subscription->ends_at==""): ?>
                                <div class="col-md-5">
                                    <a href="javascript:void(0);" onclick="confirm_cancel('<?=$pack->name?>')" class="btn btn-danger">Cancel Subscription</a>
                                </div>
                                <?php endif; ?>
                                <div class="col-md-5">
                                    <a href="javascript:void(0);" onclick="confirm_cancel_now('<?=$pack->name?>')" class="btn btn-danger">Cancel Subscription Now</a> &nbsp;
                                </div>
                                
                            </div>
                            
                            
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Card Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Card Type :</strong> <span class="m-l-15"><?php echo e(strtoupper($r->card_brand)); ?></span></p>
                    <p class="text-muted font-13"><strong>Card Number :</strong> <span class="m-l-15">XXXX-XXXX-XXXX-<?php echo e($r->card_last_four); ?></span></p>
                    
                </div>
                
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="row">
    <div class="col-md-12">
        <!-- Personal-Information -->
        <div class="card-box table-responsive">
            <h4 class="header-title mt-0 m-b-20">Profile Notes</h4>
            <div class="panel-body">
                <table id="datatable" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Note</th>
                            <th>Create Date</th>
                        </tr>
                    </thead>
                    <?php if(!empty($notes)): ?>
                    <tbody>
                        <?php $__currentLoopData = $notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td><?php echo e($n->notes); ?></td>
                            <td><?php echo e(date('m-d-Y h:i a',strtotime($n->created_at))); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <!-- Personal-Information -->
        <div class="card-box table-responsive">
            <h4 class="header-title mt-0 m-b-20">Orders</h4>
            <div class="panel-body">
                <table id="datatable_order" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Payment</th>
                            <th>Transaction/Subscription ID</th>
                            <th>Payment Status</th>
                            <th>Order Type</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <?php if(!empty($order)): ?>
                    <tbody>
                    <?php $__currentLoopData = $order; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($o->id); ?></td>
                        <td><?php echo e($o->payment); ?></td>
                        <td><?php echo e($o->transaction_id); ?></td>
                        <td>
                            <?php if($o->payment_status == "Paid"): ?>
                            <span class='label label-success'>Paid</span>
                            <?php else: ?>
                            <span class='label label-danger'><?php echo e($o->payment_status); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($o->order_type == "1"): ?>
                            <span class='label label-success'>Subscription</span>
                            <?php elseif($o->order_type == "2"): ?>
                            <span class='label label-warning'>One time setup service</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo order_status($o->status); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>

<script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables/dataTables.bootstrap4.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/plugins/datatables/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables/responsive.bootstrap4.min.js')); ?>"></script>
<script type="text/javascript">
$(function(){
    $(this).active_menu("customer");
    $('#datatable').dataTable();
    $('#datatable_order').dataTable();
});
</script>

<script type="text/javascript">
    function confirm_cancel(package){
        var x = confirm('Are you sure you want to cancel subscription ?');
        if(x == true){
            window.location.href='/admin/cancel-subscription/'+package+"/"+<?php echo e($r->id); ?>;
        }
    }
    function confirm_cancel_now(package){
        var x = confirm('Are you sure you want cancel subscription now ?');
        if(x == true){
            window.location.href='/admin/cancel-subscription-now/'+package+"/"+<?php echo e($r->id); ?>;;
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aerocodex/public_html/portal/project/resources/views/admin/user/edit.blade.php ENDPATH**/ ?>