<?php $__env->startSection('title','Notification - Edit'); ?>
<?php $__env->startSection('header_extra'); ?>
<link href="<?php echo e(asset('assets/plugins/summernote/summernote.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Notification Edit</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        <?php echo $__env->make('widget/notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <form class="form-horizontal validate" action="<?php echo e(route('admin.notification.edit_update',$r->id)); ?>" method="post" role="form" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Particular Customer</label>
                                <div class="col-8">
                                    <select class="form-control select2" name="to_id">
                                        <option value="">All Customer</option>
                                        <?php if(!empty($customer)): ?>
                                        <?php $__currentLoopData = $customer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($c->id); ?>"  <?php echo e(($c->id  == $r->to_id ? "selected":"")); ?>><?php echo e($c->name.' '.$c->last_name.'('.$c->company_name.')'); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Message <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <textarea class="form-control" name="message" required=""><?php echo e($r->message); ?></textarea>
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">&nbsp;</label>
                               <div class="col-8">
                                    <div class="checkbox checkbox-primary">
                                        <input id="checkbox2" type="checkbox" name="dashboard" value="1" <?php echo e(( $r->dashboard == "1" ? "checked":"")); ?>>
                                        <label for="checkbox2">
                                            Show Dashboard
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/plugins/parsleyjs/parsley.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/summernote/summernote.min.js')); ?>"></script>
<script type="text/javascript">
    $('.validate').parsley();
    $(function(){
        $(this).active_menu("subscription");
        
        
    });
    $('.summernote').summernote({
        height: 350,                 // set editor height
        minHeight: null,             // set minimum height of editor
        maxHeight: null,             // set maximum height of editor
        focus: false                 // set focus to editable area after initializing summernote
    });
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aerocodex/public_html/portal/project/resources/views/admin/notification/edit.blade.php ENDPATH**/ ?>