<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Auth\AuthenticationException; 
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Exceptions\ThrottleRequestsException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {

        if ($exception instanceof ThrottleRequestsException && $request->wantsJson()) {
            return json_encode([
                'message' => 'Too many attempts, please slow down the request.',
                'status' => false
            ]);
        }
        if($request->wantsJson()){
            
            if ($exception instanceof \Symfony\Component\HttpKernel\Exception\NotFoundHttpException or $exception instanceof \Illuminate\Database\Eloquent\ModelNotFoundException) {
                return response()->json([
                    'data' => 'Not Found'
                ], 404);
            }
            
//            if ($exception instanceof \PDOException) {
//                return response()->json([
//                    'data' => 'Database Error. Invalid request params'
//                ], 400);
//            }
            
        }else{
            
            
            if ($exception instanceof ModelNotFoundException )
                
            {
                return response()->json([
                    'data' => 'Not found'
                ], 404);
            }
            
        }
        
//        
//        if ($exception instanceof ModelNotFoundException && $request->wantsJson()) {
//            return response()->json(['message' => 'Not Found!'], 404);
//        }
//        if ($exception instanceof \Symfony\Component\HttpKernel\Exception\NotFoundHttpException or $exception instanceof \Illuminate\Database\Eloquent\ModelNotFoundException && $request->wantsJson()) {
//            return response()->json([
//                'data' => 'Not Found'
//            ], 404);
//        }
        return parent::render($request, $exception);
    }
    
    protected function unauthenticated($request, AuthenticationException $exception){
        if ($request->expectsJson()) {
            return response()->json(['error' => 'Unauthenticated.'], 401);
        }
        return redirect()->guest(route('login'));
    }
}
