<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\User;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;

class ManagerController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    function create(Request $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email',
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $input = $request->all();
        $input['password'] = Hash::make($input['password']);
        $input['owner_key']=secret_key_get();
        $input['role'] = 6;
        $input['status'] = 1;

        $user = User::create($input);
        $success['Authorization'] =  $user->createToken('MyApp')->accessToken;
        $success['name'] =  $user->name;
        $success['role'] = "Manager";
        $success['status'] = "Active";
        $success['manager_id'] = encode($user->id);
        return response()->json(['success'=>$success], $this->successStatus);

    }
    public function show(){
        $list['data'] =  UserResource::collection(User::where('owner_key',Auth::user()->secret_key)->where('role',6)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    public function single($id=0){
        $id = decode($id);
        $single['data'] =  UserResource::collection(User::where('owner_key',Auth::user()->secret_key)->where('id',$id)->where('role',6)->get());
        return response()->json(['success'=>$single], $this->successStatus);
    }
    public function edit(Request $request,$id){

        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.$id,
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }


        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }
        if(!$request->has('anotherPhone')){
            $form_data['anotherPhone'] = '';
        }
        if(!$request->has('citizenship')){
            $form_data['citizenship'] = '';
        }
        if(!$request->has('employeeID')){
            $form_data['employeeID'] = '';
        }
        if(!$request->has('address')){
            $form_data['address'] = '';
        }
        if(!$request->has('employeeID')){
            $form_data['employeeID'] = '';
        }
        if(!$request->has('city')){
            $form_data['city'] = '';
        }
        if(!$request->has('state')){
            $form_data['state'] = '';
        }
        if(!$request->has('district')){
            $form_data['district'] = '';
        }
        if(!$request->has('zipcode')){
            $form_data['zipcode'] = '';
        }
        if(!$request->has('country')){
            $form_data['country'] = '';
        }

        $data = User::find($id);
        if($data->update($form_data)){
            return response()->json(['success'=>'Record has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function delete($id){
        $id = decode($id);
        $delete=  User::where("id",$id)->delete();
        if($delete){
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function message_errors(){
        return [
            'name.required'=> 'Name should not be blank',
            'name.max'=> 'Name should not be greated than 255 characters',
            'email.unique'=>'Email already exist',
            'email.email'=>'Invalid Email',
            'password.min'=>"Minimu 6 chracters",
            'sex.in' => "Value should be [Male,Female]",

        ];
    }
}
