<?php

namespace App\Http\Middleware;

use Closure;
use Auth; 
use Redirect;
use App\User;

class ApiKeyCheck{
   
    function handle($request, Closure $next ){         
        

        $headers = apache_request_headers();
        if(isset($headers['Secret-Key']) && $headers['Secret-Key'] !="" ){
            
           
            $user = User::where('role',2)->where('secret_key',$headers['Secret-Key'])->first();
            
            if ($user) { 
                
                
                /*Checking other user belongs to secret key or not*/
                if(Auth::check()){
                    if(Auth::user()->role !=2){
                        
                        if(Auth::user()->owner_key != $headers['Secret-Key']){
                            return response()->json(['error' => 'You can not use this secret key for this user.'], 401);
                        }
                    }
                    
                }else{
                    if($request->email){
                        if(!$this->check_is_admin($request->email)){
                        
                                if($this->get_key_user_information($request->email)){
                                    $owner_key = $this->get_key_user_information($request->email);  


                                    if($owner_key != $headers['Secret-Key']){
                                        return response()->json(['error' => 'You can not use this secret key for this user.'], 401);
                                    }
                                }else{
                                    return response()->json(['error' => 'This is not valid user.'], 401);
                                }

                        }
                    }
                    
                    
                }
                
                if($user->status){
                    
                    if($user->api_status == 0){
                        return response()->json(['error' => 'Temprory your api service is stop.'], 401);
                    }
                    
                    $status_subscription = get_active_subscription($user->id);
                    if(!empty($status_subscription)){
                         return $next($request);
                    }else{
                        return response()->json(['error' => 'Sorry, you are not eligible for this service. So Please purchase the subscription package.'], 401);
                    }
                }else{
                    return response()->json(['error' => 'Temprory your account is de-active.'], 401);
                }
            }else{
                return response()->json(['error' => 'Invalid secret key.'], 401);
            }
           
        }else{
            return response()->json(['error' => 'Secret key missing.'], 401);
        }
             
        
    }
    
    function get_key_user_information($email = ''){
        $user = User::where('email', $email)->first();
        
        if($user){
            return $user->owner_key;
        }else{
            return 0;
        }
    }
    function check_is_admin($email = ''){
        $user = User::where('email', $email)->first();
        if($user){
            if($user->role ==2){
                return 1;
            }else{
                return 0;
            }
        }
    }
    
}

