<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class ApplicationLog extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            'application_id' => encode($this->applications_rel->id),
            'name' => getUserInfo($this->applications_rel->user_id,'name').' '.getUserInfo($this->applications_rel->user_id,'last_name'),
            'phone' => getUserInfo($this->applications_rel->user_id, 'phone'),

            "createddBy" =>  getUserInfo($this->assignedBy,'name').' '.getUserInfo($this->assignedBy,'last_name'),
            "createdType"=>roleName(getUserInfo($this->assignedBy,'role')),
            "description"=>  $this->description,
            'attachemntFile'=> $this->attachment,
            'attachmentURL'=>asset("uploads/applicaiton_notes/"),
            'attachemntFile'=>$this->attachment,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            "assignedBy" =>  getUserInfo($this->assignedBy,'name').' '.getUserInfo($this->assignedBy,'last_name'),
            "assignedType"=>roleName(getUserInfo($this->assignedBy,'role')),
            "assignedToName" =>getUserInfo($this->assignedTo,'name').' '.getUserInfo($this->assignedTo,'last_name'),
            "actionSet" => $this->actionSet,
            "assignedTo" =>encode($this->assignedTo),
            "assignedToRole"=>roleName(getUserInfo($this->assignedTo,'role')),
            "assignedToEmail"=>getUserInfo($this->assignedTo,'email'),
            "dueDateTime" =>$this->dueDateTime,
            'startDate'=>  $this->startDate,
            'endDate'=>  $this->endDate,
            "followStatus"=> $this->followStatus,
            'lead_id' => ""
        ];
    }
}
