<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;


class CommunicationLogSecond extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            'communication_id' => encode($this->communication_id),
            'name' => getUserInfo($this->comm_rel->studentId,'name').' '.getUserInfo($this->comm_rel->studentId,'last_name'),
            'phone' => getUserInfo($this->comm_rel->studentId,'phone'),
            "assignedBy" =>  getUserInfo($this->assignedBy,'name').' '.getUserInfo($this->assignedBy,'last_name'),
            "assignedType"=>roleName(getUserInfo($this->assignedBy,'role')),
            "assignedToName" =>getUserInfo($this->assignedTo,'name').' '.getUserInfo($this->assignedTo,'last_name'),

            "replyType"=>roleName($this->replyByRole),
            "replyBy" =>getUserInfo($this->replyBy,'name').' '.getUserInfo($this->replyBy,'last_name'),


            "actionSet" => $this->comm_rel->actionSet,
            "assignedTo" =>encode($this->assignedTo),
            "assignedToRole"=>roleName(getUserInfo($this->assignedTo,'role')),
            "assignedToEmail"=>getUserInfo($this->assignedTo,'email'),
            "dueDateTime" =>$this->dueDateTime,
            "resolutionNotes"=>$this->resolutionNotes,
            "status"=>$this->status,
            "followStatus"=>$this->followStatus,
            "notes"=>  $this->description,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
