<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class DocWorkExperience extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            $this->mergeWhen(Auth::user()->isCompany(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'studentID' => encode($this->user_id),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            
           
            'work_experience'=>asset("uploads/document/".encode($this->application_id)."/work_experience/". $this->work_experience),
            'work_experienceFile'=>$this->work_experience,
            'referenceLetter'=>asset("uploads/document/".encode($this->application_id)."/work_experience/". $this->referenceLetter),
            'referenceLetterFile'=>$this->referenceLetter,
            'payStubs'=>asset("uploads/document/".encode($this->application_id)."/work_experience/".  $this->payStubs),
            'payStubsFile'=> $this->payStubs,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
