<?php

namespace App\Http\Controllers\Api\Invoice;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Invoice\Orders;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\ServiceOrders as ServiceOrdersResource;




class OrdersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    
    function save(Request $request){
        
       
        $validator = Validator::make($request->all(), [
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
       
        
        $input = $request->all();
        
        
        $input['administer_id'] =  ownerKeyId(secret_key_get());
        $input['orderCreatedBy'] = Auth::id();
        $input['pendingPayment'] = $input['total'];
        if($request->has('studentId')){
            $input['studentId'] = decode($input['studentId']);
        }
        
        
        $data = new Orders($input);
        if($data->save()){
            return response()->json(['success'=>"Order has been created successfully",'orderId'=>  encode($data->id)], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
       
    }
    public function show(Request $request){
        
        $admin_id = ownerKeyId(secret_key_get());
        
        $usersearch =0;
        $data['email']='';
        $data['phone']='';
        $data['student']='';
        if(count($request->all())){
            $query = Orders::has('user')->with('user');
            if($request->has('phone')){
                $usersearch=1;
                $data['phone'] = $request->input('phone');
            }
            if($request->has('email')){
                $usersearch=1;
                $data['email'] = $request->input('email');
            }
            if($request->has('student')){
                $usersearch=1;
                $data['student'] = $request->input('student');
            }
            
            if($usersearch){
                
                $query = Orders::whereHas('user', function($user) use($data){
                     if($data['phone']!=""){
                        $user->where('phone','like', '%'.$data['phone'].'%');
                    }
                    if($data['email']!=""){
                        
                        $user->whereRaw('LOWER(email) like ?',strtolower($data['email']));
                    }
                    if($data['student']!=""){
                        
                        $user->where('id',decode($data['student']));
                    }
                })->with('user');
                
            }else{
                
                $query = Orders::has('user')->with('user');
                //echo "<pre>"; print_r($query->get()); echo "</pre>"; die();
            }
            
            if($request->has('status')){
                $query->where('status',$request->input('status'));
            }
            if($request->has('orderId')){
                $query->where('id',$request->input('orderId'));
            }
            
            $query->where('administer_id',$admin_id);
            
            $ordersQ = $query;
            
            
        }else{
           $ordersQ = Orders::has('user')->with('user')->where('administer_id',$admin_id); 
           //echo "<pre>"; print_r($ordersQ->get()); echo "</pre>";
        }
        
        if($request->get('page')){
            $list =  ServiceOrdersResource::collection($ordersQ->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
           $list['data'] =  ServiceOrdersResource::collection($ordersQ->get()); 
        }
        
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function single($id=0){
        $id = decode($id);
        $admin_id = ownerKeyId(secret_key_get());
        $result = Orders::has('user')->with('user')->where('administer_id',$admin_id)->where('id',$id)->get();
        $list['data'] =  ServiceOrdersResource::collection($result);
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    
    function message_errors(){
        return [
            'service'=>'Service value required',
            'taxrate'=>'Tax rate required',
        ];
    }
    
}
