<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\Model\Notification;
use Carbon\Carbon;


class NotificationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $common;
    public function __construct(){ 
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    public function create(){   
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["link" => route('admin.notification.manage'), "name" => "Notification - Manage"],["name" => "Add New"]
        ];
        $content['customer'] = \App\User::where('role',2)->get();
        return view('admin.notification.create',$content);
    }
    public function show(){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["name" => "Notification"]
        ];
        return view('admin.notification.list',$content);
    }
    public function edit($id){
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["link" => route('admin.notification.manage'), "name" => "Notification - Manage"],["name" => "Edit"]
        ];
      $content['r']=  Notification::find($id);
      $content['customer'] = \App\User::where('role',2)->get();
      return view('admin.notification.edit',$content);  
    }
    
    public function store(Request $request){
        
        $request->validate([
            'message' => 'required',
        ]);        
        $form_data = $request->all();
        $form_data['from_id'] = Auth::id();
        $form_data['type'] ='admin_to_customer_notification';
        
        
        $data = new Notification($form_data);       
        if($data->save()){
            $request->session()->flash('success', 'Notification created successfully!');
            return redirect(route('admin.notification.create'));
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect(route('admin.notification.create'));
        }
    }  
    public function update(Request $request,$id){
        $request->validate([
            'message' => 'required',
            
        ]); 
        $form_data = $request->all();
        $form_data['type'] ='admin_to_customer_notification';
        if($request->has('dashboard')){
            $form_data['dashboard'] = 1;
        }else{
            $form_data['dashboard'] = 0;
        }
        $data = Notification::find($id);  
        
        if($data->update($form_data)){
            $request->session()->flash('success', 'Notification updated successfully!');
            return redirect(route('admin.notification.manage'));
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect(route('admin.notification.manage'));
        }
    }
    
    function showList(){        
        $record = Notification::where('type','admin_to_customer_notification');        
        return Datatables::of($record) 
           ->editColumn('status',function($record) {
               if($record->status){
                  return "<span class='label label-success'>Read</span>";
               }else{
                   return "<span class='label label-danger'>Un-Read</span>";
               }
            }) 
            ->editColumn('user',function($record){
                if(!empty($record->userinfo_for_admin)){
                    return "<a target='_blank' href='".route('admin.user.editForm',$record->userinfo_for_admin->id)."'>".$record->userinfo_for_admin->name.' '.$record->userinfo_for_admin->last_name.'</a>';
                }else{
                    return "Send to all";
                }
            })
            ->editColumn('dashboard',function($record) {
               if($record->dashboard){
                  return "<span class='label label-success'>Yes</span>";
               }else{
                   return "<span class='label label-danger'>No</span>";
               }
            }) 
            ->addColumn('actions',function($record) {
                $actions = '<a href="'. route('admin.notification.editForm',$record->id).'" class="on-default"><i class="fa fa-pencil"></i></a> &nbsp;';
                $actions.= '<a href="javascript:void(0);" data-url="'. route('admin.notification.deleteAjax',$record->id).'" class="on-default sa-warning"><i class="fa fa-trash"></i></a> &nbsp;';
                return $actions;
            })
            ->editColumn('created_at',function($record) {
                return date('m-d-Y h:i a',strtotime($record->created_at));
            })
            ->rawColumns(['actions','status','user','dashboard','message'])
            ->make(true);            
    }   
    
    function delete($id){
        
        echo Notification::where("id",$id)->delete();
        die();
    }
    
    
    /*Particular User Pannel*/
    
    public function show_user(){
        $content['pageConfigs'] = ['pageHeader' => true];
        if(Auth::user()->role == 1){
            $content['breadcrumbs'] = [
                ["link" => route('admin.home'), "name" => "Home"],["name" => "Notification - Pannel"]
              ];
        }else{
           $content['breadcrumbs'] = [
                ["link" => route('customer.home'), "name" => "Home"],["name" => "Notification - Pannel"]
              ]; 
        }
        
        return view('notification.list',$content);
    }
    function view(Request $request, $id=0){
        
        $content['pageConfigs'] = ['pageHeader' => true];
        if(Auth::user()->role == 1){
            $content['breadcrumbs'] = [
                ["link" => route('admin.home'), "name" => "Home"],["name" => "Notification - Pannel"],['name'=>'View']
              ];
        }else{
           $content['breadcrumbs'] = [
                ["link" => route('customer.home'), "name" => "Home"],["name" => "Notification - Pannel"],['name'=>'View']
              ]; 
        }
        $content['r'] = Notification::with('userinfo_from')->where('id',$id)->first();
        if(!empty($content['r'])){
            if($content['r']->to_id != NULL){
                if($content['r']->to_id != Auth::id()){
                    $request->session()->flash('error', 'Invalid request!');
                    return redirect(route('notification.manage'));
                }
            }
            
        }
        return view('notification.view',$content);
        
    }
    
    function showList_user(){ 
        
       // $record = Notification::whereIn('to_id',[Auth::id(),NULL]); 
        if(Auth::user()->role == 1){
            $record = Notification::where('to_id',Auth::id());
        }else{
            $record = Notification::where('to_id',Auth::id())->OrWhere('to_id',Null)->where('created_at','>',Carbon::parse(Auth::user()->created_at));
        }
         
        return Datatables::of($record)
                
           ->editColumn('message',function($record) {
              
               read_status($record->id);
               if($record->status == 0){
                    return  "<strong>".$record->message.'</strong>'." ". "<span class='label label-success'>New</span>";
               }else{
                   return $record->message;
               }
            }) 
            ->editColumn('created_at',function($record) {
                return date('m-d-Y h:i a',strtotime($record->created_at));
            })
            
            ->addColumn('actions',function($record) {
                $actions = '<a href="'. route('notification.view',$record->id).'" class="on-default"><i class="fa fa-laptop"></i></a> &nbsp;';
                
                return $actions;
            })
            ->rawColumns(['actions','message'])
            ->make(true);            
    }   
    
}
