<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class LeadsLogSecond extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            'lead_id' => encode($this->leads_id),
            'name' => $this->leads_rel->firstName.' '.$this->leads_rel->lastName,
            'phone' => $this->leads_rel->phoneNumber,
            "assignedBy" =>  getUserInfo($this->assignedBy,'name').' '.getUserInfo($this->assignedBy,'last_name'),
            "assignedType"=>roleName(getUserInfo($this->assignedBy,'role')),
            "assignedToName" =>getUserInfo($this->assignedTo,'name').' '.getUserInfo($this->assignedTo,'last_name'),

            "replyType"=>roleName($this->replyByRole),
            "replyBy" =>getUserInfo($this->replyBy,'name').' '.getUserInfo($this->replyBy,'last_name'),

            "assignedTo" =>encode($this->assignedTo),
            "assignedToRole"=>roleName(getUserInfo($this->assignedTo,'role')),
            "assignedToEmail"=>getUserInfo($this->assignedTo,'email'),
            "dueDateTime" =>$this->dueDateTime,
            "resolutionNotes"=>$this->resolutionNotes,
            "status"=>$this->status,
            "notes"=>  $this->description,
            "notesExtra" => $this->notes,
            'attachemntFile'=> $this->attachment,
            'attachemnt'=>asset("uploads/leads/". $this->attachment),
            "followStatus"=>$this->followStatus,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'actionSet' => $this->actionSet


        ];
    }
}
