<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class ResetPassword extends Notification
{
    public $token;

    public function __construct($token)
    {
        $this->token = $token;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Reset Password')
            ->greeting('Reset your '.config('app.name').' Account Password')    
            ->line('This is to notify you that the password of your account ('.$notifiable->email.') was recently changed '.date('m-d-Y').' from this ip address '.$_SERVER['REMOTE_ADDR'].'. If you did not raise this request then you should consider resetting your account password.')
            ->action('Reset Password', url('password/reset', $this->token))
            ->line("If you don't verify your email address, we’re required to temporarily put your account on hold until verification is complete.* Thanks for being an ". config('app.name')." customer.");
    }
}