<?php

namespace App\Providers;

use Carbon\Carbon;
use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;



class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        
        VerifyEmail::toMailUsing(function ($notifiable) {
            $verifyUrl = URL::temporarySignedRoute(
                'verification.verify', Carbon::now()->addMinutes(60), ['id' => $notifiable->getKey()]
            );

            return (new MailMessage)
                ->subject('Welcome!')
                ->markdown('emails.verify', ['url' => $verifyUrl]);
        });
      
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $settings = app(\App\Http\Controllers\Api\SettingsController::class)->show();
        if(isset($settings->original['data'])) {
            config(['app.settings' => $settings->original['data']]);
        } else {
            $settings = array(
                'currency' => 'CAD',
                'date_format' => 'm-d-Y',
                'time_format' => '12',
                'time_zone' => 'America/New_York'
            );
            $object = new \stdClass();
            foreach ($settings as $key => $value)
            {
                $object->$key = $value;
            }
            config(['app.settings' => $object]);
        }
    }
    
    
}
