<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\CommonController;
use App\User;
use Auth;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\Users as UserResource;
use Validator;
use App\Http\Resources\Instruction as InstructionsResource;
use App\Http\Resources\Email as EmailResource;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    public function __construct()
    {
        $this->middleware('auth');
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function show(){
        if(Auth::user()->role == "2"){
            $list['data'] =  UserResource::collection(User::where('secret_key',Auth::user()->secret_key)->where('id',Auth::id())->get());
        }else{
            $list['data'] =  UserResource::collection(User::where('owner_key',Auth::user()->owner_key)->where('id',Auth::id())->get());
        }

        return response()->json(['success'=>$list], $this->successStatus);
    }



    function edit(Request $request){


        switch(Auth::user()->role){
            case "2":
                return $this->adminEdit($request);
                break;
            case "3":
                return $this->agentEdit($request);
                break;
            case "4":
                return $this->studentEdit($request);
                break;
            case "5":
                return $this->staffEdit($request);
                break;
            case "6":
                return $this->managerEdit($request);
                break;
            case "7":
                return $this->associateEdit($request);
                break;
            default:
                return response()->json(['error'=>'Error, Invalid user type.'], 401);

        }

    }

    function adminEdit($request){
        $validator = Validator::make($request->all(), [
            'name' => 'bail|required',
            'email' => 'required|string|email|unique:users,email,'.Auth::id()
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }

        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function agentEdit( $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.Auth::id(),
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $form_data = $request->all();

        if(!$request->has('anotherPhone')){
            $form_data['anotherPhone'] = '';
        }
        if(!$request->has('citizenship')){
            $form_data['citizenship'] = '';
        }

        if(!$request->has('address')){
            $form_data['address'] = '';
        }

        if(!$request->has('city')){
            $form_data['city'] = '';
        }
        if(!$request->has('state')){
            $form_data['state'] = '';
        }
        if(!$request->has('district')){
            $form_data['district'] = '';
        }
        if(!$request->has('zipcode')){
            $form_data['zipcode'] = '';
        }
        if(!$request->has('country')){
            $form_data['country'] = '';
        }
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }

        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }

    function associateEdit( $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.Auth::id(),
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }

        if(!$request->has('anotherPhone')){
            $form_data['anotherPhone'] = '';
        }
        if(!$request->has('employeeID')){
            $form_data['employeeID'] = '';
        }
        if(!$request->has('citizenship')){
            $form_data['citizenship'] = '';
        }

        if(!$request->has('address')){
            $form_data['address'] = '';
        }

        if(!$request->has('city')){
            $form_data['city'] = '';
        }
        if(!$request->has('state')){
            $form_data['state'] = '';
        }
        if(!$request->has('district')){
            $form_data['district'] = '';
        }
        if(!$request->has('zipcode')){
            $form_data['zipcode'] = '';
        }
        if(!$request->has('country')){
            $form_data['country'] = '';
        }

        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }

    function studentEdit( $request){
       $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.Auth::id(),
            'sex' => 'in:Male,Female',
            'applyFor' => 'in:Study_Visa,Work_Visa,Visitor_Visa,Permanent_Residency,Spouse_Application,Other',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }

        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }

        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    function staffEdit( $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.Auth::id(),
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }

        if(!$request->has('anotherPhone')){
            $form_data['anotherPhone'] = '';
        }
        if(!$request->has('citizenship')){
            $form_data['citizenship'] = '';
        }
        if(!$request->has('employeeID')){
            $form_data['employeeID'] = '';
        }

        if(!$request->has('address')){
            $form_data['address'] = '';
        }

        if(!$request->has('city')){
            $form_data['city'] = '';
        }
        if(!$request->has('state')){
            $form_data['state'] = '';
        }
        if(!$request->has('district')){
            $form_data['district'] = '';
        }
        if(!$request->has('zipcode')){
            $form_data['zipcode'] = '';
        }
        if(!$request->has('country')){
            $form_data['country'] = '';
        }

        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }
    function managerEdit( $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.Auth::id(),
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);
        }
        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }

        if(!$request->has('employeeID')){
            $form_data['employeeID'] = '';
        }
        if(!$request->has('anotherPhone')){
            $form_data['anotherPhone'] = '';
        }
        if(!$request->has('citizenship')){
            $form_data['citizenship'] = '';
        }

        if(!$request->has('address')){
            $form_data['address'] = '';
        }

        if(!$request->has('city')){
            $form_data['city'] = '';
        }
        if(!$request->has('state')){
            $form_data['state'] = '';
        }
        if(!$request->has('district')){
            $form_data['district'] = '';
        }
        if(!$request->has('zipcode')){
            $form_data['zipcode'] = '';
        }
        if(!$request->has('country')){
            $form_data['country'] = '';
        }

        $data =  User::find(Auth::id());
        if($data->update($form_data)){
            return response()->json(['success'=>'Profile has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }

    function instruction(){

        $list['data'] =  InstructionsResource::collection(\App\Model\Api\Instruction::where('user_id',ownerKeyId(Auth::user()->owner_key))->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function getEmailid($id=0){
        if($id == "agent"){
            $id = Auth::user()->agent_id;
        }elseif($id == "admin"){
            $id = ownerKeyId(Auth::user()->owner_key);
        }else{
            $id = decode($id);
        }
        $list['data'] =  EmailResource::collection(User::where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    /*Cron JOB*/
    function users(){
        $list['data'] = UserResource::collection(User::where('owner_key',Auth::user()->owner_key)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    function application(){
        $list['data'] = UserResource::collection(User::where('owner_key',Auth::user()->owner_key)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function message_errors(){
        return [
            'name.required'=> 'Name should not be blank',
            'name.max'=> 'Name should not be greated than 255 characters',
            'email.unique'=>'Email already exist',
            'email.email'=>'Invalid Email',
            'password.min'=>"Minimu 6 chracters",
            'sex.in' => "Value should be [Male,Female]"
        ];
    }
}
