<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class RetrainerAgreement extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            $this->mergeWhen(Auth::user()->isCompany(), [
                'id' => encode($this->id),
                'assignByAgent' =>($this->assignedByAgent!=0 ? $this->assignerAgent->name .' '.$this->assignerAgent->last_name:""),
                'assignByAgentID' =>($this->assignedByAgent!=0 ? encode($this->assignedByAgent):""),
                'studentID' => encode($this->studentID),
                'studentName' => $this->user->name.' '.$this->user->last_name,
                
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'id' => encode($this->id),
                'assignByAgent' =>($this->assignedByAgent!=0 ? $this->assignerAgent->name .' '.$this->assignerAgent->last_name:""),
                'assignByAgentID' =>($this->assignedByAgent!=0 ? encode($this->assignedByAgent):""),
                'studentID' => encode($this->studentID),
                'studentName' => $this->user->name.' '.$this->user->last_name,
                
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'id' => encode($this->id),
                'assignBy' => ($this->assignedByAgent ==  Auth::id() ? "You":"Admin"),
                'studentID' => encode($this->studentID),
                'studentName' => $this->user->name.' '.$this->user->last_name,
                
            ]),
            $this->mergeWhen(Auth::user()->isClient(), [
                'assignBy' => ($this->assignedByAgent == 0 ? "Admin":"Agent"),
             ]),
            'agreementFile' => asset("uploads/document/retrainer_agreement/".$this->agreementFile) ,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
