<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;


class AuthController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    
    public $successStatus = 200;
   

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('guest')->except('logout');
    }
  
    
    public function login(Request $request){
       
        $rules = [
            'email' => 'required|string|email|max:255', 
            'password' => 'required|string|min:6',
        ];

        $input     = $request->only('email','password');
        $validator = Validator::make($input, $rules);
        
        
        if ($validator->fails()) {
            return response()->json(['error' => $validator->messages()]);
        }
        if(getUserEnable($request->input('email')) == 0){
            return response()->json(['error'=>'Your account does not have the correct permissions to access this profile'], 401);
        }
        if(Auth::attempt(['email' => request('email'), 'password' => request('password'),'status'=>1])){
            $user = Auth::user();
            $success['token'] =  $user->createToken('MyApp')->accessToken;
            $success['name'] = $user->name.' '.$user->last_name;
            $success['id'] = encode($user->id);
            $success['adminID'] = encode(ownerKeyId(secret_key_get()));
            $success['email'] = $user->email;
            $success['role'] = $this->role_get($user->role);
            $success['two_way_authentication_email'] = $user->two_way_authentication_email;
            $success['two_way_authentication'] = $user->two_way_authentication;
            return response()->json(['success' => $success], $this->successStatus);
        }else{
            return response()->json(['error'=>'Invalid login details'], 401);
        }
    }
    
    public function logout(Request $request){
       
        if (Auth::check()) {
            Auth::user()->AauthAcessToken()->delete();
            return response()->json(['data' => 'User logged out.'], 200);
        }else{
            return response()->json(['data' => 'Invalid Request.'], 401);
        }
        
    }
    function role_get($role=''){
        switch ($role){
            case "2":
                return "admin";
                break;
            case "3":
                return "agent";
                break;
            case "4":
                return "student";
                break;
            case "5":
                return "staff";
                break;
            case "6":
                return "manager";
                break;
            case "7":
                return "associate";
                break;    
        }
    }

    function password_reset(Request $request){
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email',
            'password' => 'required'
        ],  $this->message_errors());

        if($request->input('password') !=""){
            $form_data['password'] = Hash::make($request->input('password'));
        }

        $data = User::where('email',$request->input('email'));
        if($data->update($form_data)){
            return response()->json(['success'=>'Password has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }

    }

    function message_errors(){
        return [
            'email.required'=>'Email required',
            'password'=>'Password required'
            
        ];
    }
}
