<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Settings;

use Validator;
use DB;



class SettingsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){
        $this->common=new CommonController();
    }

    
    function update(Request $request){
        $validator = Validator::make($request->all(), [
            'time_zone' => 'required',
            'date_format' => 'required',
            'time_format' =>'required',
            'currency' =>'required',
        ],  $this->message_errors());

        $input['time_zone'] = $request->input('time_zone');
        $input['date_format'] = $request->input('date_format');
        $input['time_format'] = $request->input('time_format');
        $input['currency'] = $request->input('currency');

        $count = Settings::where('administer_id',  ownerKeyId( secret_key_get() ))->count();
        if($count == 0) {
            $input['administer_id'] = ownerKeyId( secret_key_get() );
            $query = DB::table('settings')->insert($input);
        } else {
            $query = DB::table('settings')->where('administer_id',  ownerKeyId( secret_key_get() ))->update($input);
        }


        if($query){
            return response()->json(['success'=>"Settings updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }

    public function show(){
        $list = Settings::where('administer_id',  ownerKeyId( secret_key_get() ))->first();
        if(!$list) {
            $list = Settings::where('administer_id',  NULL)->first();
        }
        return response()->json(['success'=> true, 'data' => $list], $this->successStatus);
    }
    
    function message_errors(){
        return [
            'date_format'=>'Date format required',
            'time_format'=>'Time format required',
            'currency'=>'Currency required',
            'time_zone'=>'Timezone required',
        ];
    }

}
