<?php

namespace App\Model\Api;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Communication extends Model{
  
   
   protected $table="communication";
   protected $fillable=[
       'studentId',
       'user_id',
       'openBy',
       'source',
       'service',
       'notes',
       'actionSet',
       'status',
       'resolutionNotes',
       'assignedTo',
       'resolutionNotes',
       'comm_id',
       'administer_id',
       'startDate',
       'endDate',
       'applicationId',
       'name',
       'custom_field_data'
   ];
   
   function user(){
        $query =  $this->belongsTo('App\User','studentId','id');
        if (Auth::check()) {
            if(Auth::user()->role == 2){
                $query->where('owner_key',Auth::user()->secret_key);
            }elseif (Auth::user()->role == 3){
                $query->where('owner_key',Auth::user()->owner_key);
                //$query->where('agent_id',Auth::id());
            }elseif (Auth::user()->role == 5){
                $query->where('owner_key',Auth::user()->owner_key);
            }elseif (Auth::user()->role == 6){
                $query->where('owner_key',Auth::user()->owner_key);
            }
        }else{
            $secret_key = apache_request_headers();
            $query->where('owner_key',$secret_key['Secret-Key']);
        }
        return $query;
   }
   function comm_log(){
       return $this->hasMany('App\Model\Api\CommunicationLog','communication_id','id');
       
   }
   function userCron(){
       return $this->belongsTo('App\User','studentId','id');
   }
}
