<?php

namespace App\Model\Api\Invoice;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Invoice extends Model{
  
   
   protected $table="api_service_invoice";
   protected $fillable=[
       'administer_id',
       'invoice_id',
       'studentId',
       'order_id',
       'dateof',
       'items',
       'amount',
       'taxRate1',
       'taxAmount1',
       'taxRate2',
       'taxAmount2',
       'grand_total',
       'generatedBy',
       'paymentType',
       'baseAmount',
       'cancel_by',
       'status_cancel',
       'notes',
       'email_sent'
   ]; 
   
   
   function user(){
        $query =  $this->belongsTo('App\User','generatedBy','id');
        if(Auth::user()->role == 2){
            $query->where('owner_key',Auth::user()->secret_key);
        }else{
            $query->where('owner_key',Auth::user()->owner_key);
        }
        return $query;
   }
   
   function student(){
        $query =  $this->belongsTo('App\User','studentId','id');
        if(Auth::user()->role == 2){
            $query->where('owner_key',Auth::user()->secret_key);
        }else{
            
            $query->where('owner_key',Auth::user()->owner_key);
            if(Auth::user()->role == 3){
                $query->where('agent_id',Auth::id());
            }
        }
        return $query;
   }
   
}
