<?php

namespace App\Model\Api\Invoice;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Orders extends Model{
  
   
   protected $table="api_service_order";
   protected $fillable=[
       'administer_id',
       'studentId',
       'dateoforder',
       'products',
       'total',
       
       'status',
       'totalPaymentComplete',
       'pendingPayment',
       'orderCreatedBy'
   ]; 
   
   function user(){
        $query =  $this->belongsTo('App\User','studentId','id');
        if (Auth::user()) { 
          if(Auth::user()->role == 2){
              $query->where('owner_key',Auth::user()->secret_key);
          }else{
              
              $query->where('owner_key',Auth::user()->owner_key);
              if(Auth::user()->role == 3){
                  $query->where('agent_id',Auth::id());
              }
          }
        }
        return $query;
   }
   
}
