<?php

namespace App;

use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Cashier\Billable;
use App\Notifications\ResetPassword as ResetPasswordNotification;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasApiTokens, Notifiable, Billable;
   
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 
        'email', 
        'password',
        'email_verified_at',
        'role',
        'status',
        'last_name',
        'address',
        'city',
        'state',
        'country',
        'zipcode',
        'phone',
        'picture',
        'company_name',
        'website',
        'company_email',
        'company_phone',
        'district',
        'mailingAddSame',
        'owner_key',
        'agent_id',
        'placeBirth',
        'dateOfbirth',
        'anotherPhone',
        'sex',
        'citizenship',
        'passportNumber',
        'martialStatus',
        'nativeLanguage',
        'district',
        'mailingAddress',
        'educationDetails',
        'applyFor',
        'applyForOther',
        'whichCountry',
        'employeeID',
        'experience',
        'delete_record',
        'stripe_id',
        'card_brand',
        'card_last_four',
        'familyInformation',
        'number_employee',
        'mailingAddSame',
        'client_enable',
        'two_way_authentication',
        'two_way_authentication_email'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function isAdmin(){
        if($this->role == 1){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    public function isCompany(){
        if($this->role == 2){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    public function isAgents(){
        if($this->role == 3){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    public function isClient(){
        if($this->role == 4){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    
    public function isStaff(){
        if($this->role == 5){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    public function isManager(){
        if($this->role == 6){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    public function isAssociates(){
        if($this->role == 7){ 
            return true; 
        } 
        else { 
            return false; 
        }
    }
    
    public function AauthAcessToken(){
        return $this->hasMany('\App\OauthAccessToken');
    }
    function isCompanyActive(){
    }
    
    public function sendPasswordResetNotification($token)
    {
        // Your your own implementation.
        $this->notify(new ResetPasswordNotification($token));
    }
    
}
