<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Auth;
use App\Model\Orders;
use App\User;


class OrdersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $common;
    public function __construct(){     
        $this->middleware('admin.permissions');
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    
    public function show(){
        $content['pageConfigs'] = ['pageHeader' => true];
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["name" => "Orders"]
        ];
        return view('admin.orders.list',$content);
    }
    public function view($id){
        $content['breadcrumbs'] = [
          ["link" => route('admin.home'), "name" => "Home"],["link" => route('admin.order.manage'), "name" => "Orders - Manage"],["name" => "View"]
        ];
      $content['r']=  Orders::find($id);
      $content['invoice'] = \App\Model\Invoice::where('order_id',$id)->first();
      return view('admin.orders.view',$content);  
    }
    
    
    public function update(Request $request,$id){
        
        $form_data = $request->all();
        $data = Orders::find($id);  
        $info = $data->first();
        
        if($data->update($form_data)){
            if($form_data['status'] != "0"){
                
                if($form_data['status'] == "2"){
                    $status = "Refund";
                }
                if($form_data['status'] == "3"){
                    $status = "Cancelled";
                }
                $email['heading'] ='Order#'.$id.' - status change to '.$status;;
                $email['content'][] = "Your order has been changed to ".$status;
                $view = View('emailtemplates.notification',$email); 
                $content =$view->render();
                $user = User::find($info->user_id);
                $this->common->sendSMTPSystem($user->email, 'Order#'.$id.' status change',$content);
            }
            $request->session()->flash('success', 'Orders updated successfully!');
            return redirect(route('admin.order.manage'));
        }else{
            $request->session()->flash('error', 'Error!');
            return redirect(route('admin.order.manage'));
        }
    }
    
    function showList(){        
        $record = Orders::with('user');        
        return Datatables::of($record) 
           ->editColumn('customer',function($record){
               return "<a target='_blank' href='".route('admin.user.editForm',$record->user->id)."'>".$record->user->name .' '.$record->user->last_name. "</a>";
           })  
           ->editColumn('payment_status',function($record) {
               if($record->payment_status == "Paid"){
                  return "<span class='label label-success'>Paid</span>";
               }else{
                   return "<span class='label label-danger'>".$record->payment_status."</span>";
               }
           })
           ->editColumn('order_type',function($record) {
               if($record->order_type == "1"){
                  return "<span class='label label-success'>Subscription</span>";
               }else{
                   return "<span class='label label-warning'>One time setup service</span>";
               }
           })
           ->editColumn('status',function($record) {
               if($record->status == "2"){
                   return "<span class='label label-success'>Refund</span>";
               }elseif($record->status == "3"){
                   return "<span class='label label-danger'>Cancelled</span>";
               }
               else{
                   return "<span class='label label-info'>Completed</span>";
               }
               
            })   
            ->editColumn('created_at',function($record){
                return date('m-d-Y h:i A',  strtotime($record->created_at));
            })
            ->addColumn('actions',function($record) {
                $actions = '<a href="'. route('admin.order.view',$record->id).'" class="on-default"><i class="fa fa-pencil"></i></a> &nbsp;';
                
                return $actions;
            })
            ->rawColumns(['actions','status','customer','payment_status','order_type'])
            ->make(true);            
    }   
    
    function delete($id){
        echo Orders::where("id",$id)->delete();
        die();
    }
    
    
    function export(){
        $order = Orders::with('user')->orderBy('id', 'desc')->get();
        $cnt=0;
        foreach($order as $ord) {
            $rows[$cnt][] = $ord->user->name.' '.$ord->user->last_name;
            $rows[$cnt][] = $ord->payment;
            $rows[$cnt][] = $ord->payment_status;
            $rows[$cnt][] = $ord->transaction_id;
            if($ord->type == "1"){
                $rows[$cnt][] = 'Subscription';
            }else{
                $rows[$cnt][] = 'One time setup service';
            }
            if($ord->status == "2"){
                 $rows[$cnt][] = 'Refund';
            }elseif($ord->status == "3"){
                $rows[$cnt][] = 'Cancelled';
            }else{
                $rows[$cnt][] = 'Completed';
            }
            $rows[$cnt][] = date('m-d-Y h:i A',  strtotime($ord->created_at));
            
            $cnt++;
        }
        $columnNames = ['Customer Name', 'Payment','Payment Status', 'Transaction ID','Order Type', 'Order Status', 'Order Date'];
        return self::getCsv($columnNames, $rows,'customer.csv');
    }
    
    public static function getCsv($columnNames, $rows, $fileName = 'file.csv') {
        $headers = [
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=" . $fileName,
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        ];
        $callback = function() use ($columnNames, $rows ) {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columnNames);
            foreach ($rows as $row) {
                fputcsv($file, $row);
            }
            fclose($file);
        };
        return response()->stream($callback, 200, $headers);
    }
    
}
