<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class ServiceOrders extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
           
            'id' => encode($this->id),
            'orderId'=>  $this->id,
            'studentID' => encode($this->studentId),
            'studentName' => $this->user->name.' '.$this->user->last_name,
            'studentDateofbirth' => $this->user->dateOfbirth,
            'studentPhone' => $this->user->phone,
            'studentEmail' => $this->user->email,
            'studentAddress' => $this->user->address, 
            'studentCity' => $this->user->city, 
            'studentState' => $this->user->state, 
            'studentCountry' => $this->user->country,
            'studentZipcode' => $this->user->zipcode, 
            'dateOfOrder'=>  $this->dateoforder,
            'services' => $this->products,
            'total' => $this->total,
            'status'=> $this->status,
            'totalPaymentComplete' => $this->totalPaymentComplete,
            'pendingPayment' => $this->pendingPayment,
            'orderGenerateBy' =>  getUserInfo($this->orderCreatedBy,'name').' '.getUserInfo($this->orderCreatedBy,'last_name'),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
